<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    
    <!-- Page Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Deposit Funds</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Add funds to your trading account</p>
        </div>
        <div class="px-4 py-2 bg-blue-50 dark:bg-blue-900/20 rounded-xl">
            <div class="text-xs text-gray-600 dark:text-gray-400">Total Deposited</div>
            <div class="text-xl font-bold text-blue-600"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($deposited, 2)); ?></div>
        </div>
    </div>

    <!-- Deposit Methods -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php $__currentLoopData = $dmethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="group relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg hover:shadow-2xl transition-all cursor-pointer border-2 border-transparent hover:border-blue-500">
            <div class="absolute inset-0 bg-gradient-to-br from-blue-500/5 to-indigo-500/5 opacity-0 group-hover:opacity-100 transition-opacity"></div>
            <div class="relative">
                <div class="flex items-center justify-between mb-4">
                    <div class="p-3 bg-blue-500/10 rounded-xl">
                        <?php if(strtolower($method->name) == 'bitcoin'): ?>
                            <i data-lucide="bitcoin" class="w-8 h-8 text-orange-500"></i>
                        <?php elseif(strtolower($method->name) == 'ethereum'): ?>
                            <i data-lucide="hexagon" class="w-8 h-8 text-blue-500"></i>
                        <?php elseif(strtolower($method->name) == 'bank transfer'): ?>
                            <i data-lucide="building-2" class="w-8 h-8 text-green-500"></i>
                        <?php else: ?>
                            <i data-lucide="wallet" class="w-8 h-8 text-purple-500"></i>
                        <?php endif; ?>
                    </div>
                    <span class="px-3 py-1 bg-green-50 text-green-600 text-xs font-medium rounded-full">Active</span>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e($method->name); ?></h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Fast and secure deposit</p>
                <a href="<?php echo e(route('getmethod', $method->id)); ?>" class="inline-flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-lg font-medium hover:shadow-lg transition-all">
                    <span>Deposit Now</span>
                    <i data-lucide="arrow-right" class="w-4 h-4"></i>
                </a>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Recent Deposits -->
    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <h3 class="text-lg font-bold mb-4">Recent Deposits</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-gray-200 dark:border-gray-700">
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Date</th>
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Amount</th>
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Method</th>
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50">
                        <td class="py-3 px-4 text-sm"><?php echo e($deposit->created_at->format('M d, Y')); ?></td>
                        <td class="py-3 px-4 text-sm font-bold"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format($deposit->amount, 2)); ?></td>
                        <td class="py-3 px-4 text-sm"><?php echo e($deposit->payment_mode); ?></td>
                        <td class="py-3 px-4">
                            <?php if($deposit->status == 'Processed'): ?>
                                <span class="px-3 py-1 bg-green-50 text-green-600 text-xs font-medium rounded-full">Completed</span>
                            <?php elseif($deposit->status == 'Pending'): ?>
                                <span class="px-3 py-1 bg-yellow-50 text-yellow-600 text-xs font-medium rounded-full">Pending</span>
                            <?php else: ?>
                                <span class="px-3 py-1 bg-red-50 text-red-600 text-xs font-medium rounded-full"><?php echo e($deposit->status); ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="py-8 text-center text-gray-500">No deposits yet</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<script>
    lucide.createIcons();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.modern', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\algotrade_withdemo3\resources\views/user/deposits-modern.blade.php ENDPATH**/ ?>