<!DOCTYPE html>
<html lang="en" x-data="{ darkMode: localStorage.theme === 'dark' }" :class="{ 'dark': darkMode }">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title); ?> - <?php echo e($settings->site_name); ?></title>
    <link href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" rel="icon" type="image/x-icon" />
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 dark:from-gray-900 dark:via-slate-900 dark:to-gray-900 min-h-screen" x-cloak>
    
    <!-- Top Bar -->
    <div class="fixed top-0 left-0 right-0 h-16 bg-white/80 dark:bg-gray-900/80 backdrop-blur-xl border-b border-gray-200/50 dark:border-gray-700/50 z-50">
        <div class="h-full px-4 flex items-center justify-between">
            <div class="flex items-center gap-4">
                <button @click="$store.sidebar.toggle()" class="lg:hidden p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg">
                    <i data-lucide="menu" class="w-5 h-5"></i>
                </button>
                <img src="<?php echo e(asset('storage/app/public/'.$settings->logo)); ?>" class="h-8" alt="Logo" />
                <div class="hidden md:flex items-center gap-2 px-3 py-1.5 bg-gradient-to-r from-emerald-500/10 to-green-500/10 rounded-full">
                    <div class="w-2 h-2 bg-emerald-500 rounded-full animate-pulse"></div>
                    <span class="text-xs font-medium text-emerald-700 dark:text-emerald-400">Live Trading</span>
                </div>
            </div>
            
            <div class="flex items-center gap-3">
                <div class="hidden md:block px-4 py-2 bg-gradient-to-r from-blue-600 to-indigo-600 rounded-xl text-white">
                    <div class="text-xs opacity-80">Balance</div>
                    <div class="text-sm font-bold"><?php echo e(Auth::user()->currency); ?><?php echo e(number_format(Auth::user()->account_bal, 2)); ?></div>
                </div>
                
                <button @click="darkMode = !darkMode; localStorage.theme = darkMode ? 'dark' : 'light'" class="p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg">
                    <i data-lucide="sun" x-show="!darkMode" class="w-5 h-5"></i>
                    <i data-lucide="moon" x-show="darkMode" class="w-5 h-5"></i>
                </button>
                
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="flex items-center gap-2 p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg">
                        <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-full flex items-center justify-center text-white text-sm font-bold">
                            <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                        </div>
                    </button>
                    <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-64 bg-white dark:bg-gray-800 rounded-xl shadow-xl border border-gray-200 dark:border-gray-700 p-2">
                        <a href="<?php echo e(route('profile')); ?>" class="flex items-center gap-3 px-3 py-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg">
                            <i data-lucide="user" class="w-4 h-4"></i>
                            <span>Profile</span>
                        </a>
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full flex items-center gap-3 px-3 py-2 hover:bg-red-50 dark:hover:bg-red-900/20 rounded-lg text-red-600">
                                <i data-lucide="log-out" class="w-4 h-4"></i>
                                <span>Logout</span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <aside x-data="{ open: false }" 
           :class="open ? 'translate-x-0' : '-translate-x-full'" 
           class="fixed top-16 left-0 bottom-0 w-64 bg-white/80 dark:bg-gray-900/80 backdrop-blur-xl border-r border-gray-200/50 dark:border-gray-700/50 transition-transform lg:translate-x-0 z-40 overflow-y-auto">
        <nav class="p-4 space-y-2">
            <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('dashboard') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="layout-dashboard" class="w-5 h-5"></i>
                <span class="font-medium">Dashboard</span>
            </a>
            
            <a href="<?php echo e(route('deposits')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('deposits') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="wallet" class="w-5 h-5"></i>
                <span class="font-medium">Deposit</span>
            </a>
            
            <a href="<?php echo e(route('withdrawalsdeposits')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('withdrawalsdeposits') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="arrow-up-circle" class="w-5 h-5"></i>
                <span class="font-medium">Withdraw</span>
            </a>
            
            <a href="<?php echo e(route('mplans')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('mplans') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="trending-up" class="w-5 h-5"></i>
                <span class="font-medium">Investment Plans</span>
            </a>
            
            <a href="<?php echo e(route('myplans', 'All')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('myplans') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="briefcase" class="w-5 h-5"></i>
                <span class="font-medium">My Portfolio</span>
            </a>
            
            <a href="<?php echo e(route('tradinghistory')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('tradinghistory') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="activity" class="w-5 h-5"></i>
                <span class="font-medium">Trade History</span>
            </a>
            
            <a href="<?php echo e(route('accounthistory')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('accounthistory') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="receipt" class="w-5 h-5"></i>
                <span class="font-medium">Transactions</span>
            </a>
            
            <a href="<?php echo e(route('demo.dashboard')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('demo.*') ? 'bg-gradient-to-r from-emerald-600 to-green-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="graduation-cap" class="w-5 h-5"></i>
                <span class="font-medium">Demo Trading</span>
                <span class="ml-auto px-2 py-0.5 bg-emerald-500 text-white text-xs rounded-full">Free</span>
            </a>
            
            <a href="<?php echo e(route('referuser')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('referuser') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="users" class="w-5 h-5"></i>
                <span class="font-medium">Referrals</span>
            </a>
            
            <a href="<?php echo e(route('profile')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('profile') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="user" class="w-5 h-5"></i>
                <span class="font-medium">Profile</span>
            </a>
            
            <a href="<?php echo e(route('support')); ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl <?php echo e(request()->routeIs('support') ? 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-lg' : 'hover:bg-gray-100 dark:hover:bg-gray-800'); ?>">
                <i data-lucide="headphones" class="w-5 h-5"></i>
                <span class="font-medium">Support</span>
            </a>
        </nav>
    </aside>

    <!-- Main Content -->
    <main class="lg:ml-64 pt-16 min-h-screen">
        <div class="p-4 md:p-6 lg:p-8">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.store('sidebar', {
                open: false,
                toggle() { this.open = !this.open }
            });
        });
        lucide.createIcons();
    </script>
</body>
</html>
<?php /**PATH C:\xampp80\htdocs\algotrade_withdemo3\resources\views/layouts/modern.blade.php ENDPATH**/ ?>