@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    
    <!-- Page Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Withdraw Funds</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Request a withdrawal from your account</p>
        </div>
        <div class="px-4 py-2 bg-emerald-50 dark:bg-emerald-900/20 rounded-xl">
            <div class="text-xs text-gray-600 dark:text-gray-400">Available Balance</div>
            <div class="text-xl font-bold text-emerald-600">{{ Auth::user()->currency }}{{ number_format(Auth::user()->account_bal, 2) }}</div>
        </div>
    </div>

    <!-- Withdrawal Methods -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($wmethods as $method)
        <div class="group relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg hover:shadow-2xl transition-all cursor-pointer border-2 border-transparent hover:border-emerald-500">
            <div class="absolute inset-0 bg-gradient-to-br from-emerald-500/5 to-green-500/5 opacity-0 group-hover:opacity-100 transition-opacity"></div>
            <div class="relative">
                <div class="flex items-center justify-between mb-4">
                    <div class="p-3 bg-emerald-500/10 rounded-xl">
                        @if(strtolower($method->name) == 'bitcoin')
                            <i data-lucide="bitcoin" class="w-8 h-8 text-orange-500"></i>
                        @elseif(strtolower($method->name) == 'ethereum')
                            <i data-lucide="hexagon" class="w-8 h-8 text-blue-500"></i>
                        @elseif(strtolower($method->name) == 'bank transfer')
                            <i data-lucide="building-2" class="w-8 h-8 text-green-500"></i>
                        @else
                            <i data-lucide="wallet" class="w-8 h-8 text-purple-500"></i>
                        @endif
                    </div>
                    <span class="px-3 py-1 bg-green-50 text-green-600 text-xs font-medium rounded-full">Active</span>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">{{ $method->name }}</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Fast and secure withdrawal</p>
                <button onclick="openWithdrawModal('{{ $method->id }}', '{{ $method->name }}')" 
                        class="inline-flex items-center gap-2 px-4 py-2 bg-gradient-to-r from-emerald-600 to-green-600 text-white rounded-lg font-medium hover:shadow-lg transition-all">
                    <span>Withdraw Now</span>
                    <i data-lucide="arrow-right" class="w-4 h-4"></i>
                </button>
            </div>
        </div>
        @endforeach
    </div>

    <!-- Withdrawal History -->
    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <h3 class="text-lg font-bold mb-4">Withdrawal History</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-gray-200 dark:border-gray-700">
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Date</th>
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Amount</th>
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Method</th>
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Status</th>
                        <th class="text-left py-3 px-4 text-sm font-medium text-gray-600 dark:text-gray-400">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($withdrawals as $withdrawal)
                    <tr class="border-b border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50">
                        <td class="py-3 px-4 text-sm">{{ $withdrawal->created_at->format('M d, Y') }}</td>
                        <td class="py-3 px-4 text-sm font-bold">{{ Auth::user()->currency }}{{ number_format($withdrawal->amount, 2) }}</td>
                        <td class="py-3 px-4 text-sm">{{ $withdrawal->payment_mode }}</td>
                        <td class="py-3 px-4">
                            @if($withdrawal->status == 'Processed')
                                <span class="px-3 py-1 bg-green-50 text-green-600 text-xs font-medium rounded-full">Completed</span>
                            @elseif($withdrawal->status == 'Pending')
                                <span class="px-3 py-1 bg-yellow-50 text-yellow-600 text-xs font-medium rounded-full">Pending</span>
                            @else
                                <span class="px-3 py-1 bg-red-50 text-red-600 text-xs font-medium rounded-full">{{ $withdrawal->status }}</span>
                            @endif
                        </td>
                        <td class="py-3 px-4">
                            <button class="text-blue-600 hover:text-blue-700 text-sm font-medium">View</button>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="py-8 text-center text-gray-500">No withdrawals yet</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Withdrawal Modal -->
    <div id="withdrawModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 max-w-md w-full shadow-2xl">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-2xl font-bold">Withdraw via <span id="modalMethodName"></span></h3>
                <button onclick="closeWithdrawModal()" class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg">
                    <i data-lucide="x" class="w-5 h-5"></i>
                </button>
            </div>

            <form action="{{ route('withdrawamount') }}" method="POST" class="space-y-4">
                @csrf
                <input type="hidden" name="method_id" id="modalMethodId">
                
                <!-- Available Balance Display -->
                <div class="p-4 bg-emerald-50 dark:bg-emerald-900/20 rounded-xl">
                    <div class="text-sm text-gray-600 dark:text-gray-400">Available Balance</div>
                    <div class="text-2xl font-bold text-emerald-600">{{ Auth::user()->currency }}{{ number_format(Auth::user()->account_bal, 2) }}</div>
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Withdrawal Amount</label>
                    <div class="relative">
                        <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-500">{{ Auth::user()->currency }}</span>
                        <input type="number" name="amount" id="withdrawAmount" 
                               class="w-full pl-12 pr-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-emerald-500 dark:bg-gray-700" 
                               placeholder="0.00" 
                               max="{{ Auth::user()->account_bal }}"
                               required>
                    </div>
                    <p class="text-xs text-gray-500 mt-1">Enter amount to withdraw</p>
                </div>

                <button type="submit" class="w-full py-3 bg-gradient-to-r from-emerald-600 to-green-600 text-white rounded-xl font-bold hover:shadow-lg transition-all">
                    Continue to Withdrawal
                </button>
            </form>
        </div>
    </div>

</div>

<script>
    lucide.createIcons();

    function openWithdrawModal(methodId, methodName) {
        document.getElementById('withdrawModal').classList.remove('hidden');
        document.getElementById('withdrawModal').classList.add('flex');
        document.getElementById('modalMethodId').value = methodId;
        document.getElementById('modalMethodName').textContent = methodName;
        lucide.createIcons();
    }

    function closeWithdrawModal() {
        document.getElementById('withdrawModal').classList.add('hidden');
        document.getElementById('withdrawModal').classList.remove('flex');
    }
</script>
@endsection
