@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    <h1 class="text-3xl font-bold">Account Transactions</h1>
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <h3 class="font-bold mb-4">Deposits</h3>
            @foreach($deposits as $d)
            <div class="mb-3 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                <div class="flex justify-between"><span class="text-sm">{{ $d->created_at->format('M d') }}</span><span class="font-bold text-green-600">+{{ Auth::user()->currency }}{{ number_format($d->amount, 2) }}</span></div>
            </div>
            @endforeach
            {{ $deposits->links() }}
        </div>
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <h3 class="font-bold mb-4">Withdrawals</h3>
            @foreach($withdrawals as $w)
            <div class="mb-3 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                <div class="flex justify-between"><span class="text-sm">{{ $w->created_at->format('M d') }}</span><span class="font-bold text-red-600">-{{ Auth::user()->currency }}{{ number_format($w->amount, 2) }}</span></div>
            </div>
            @endforeach
            {{ $withdrawals->links() }}
        </div>
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <h3 class="font-bold mb-4">Other Transactions</h3>
            @foreach($t_history as $t)
            <div class="mb-3 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                <div class="flex justify-between"><span class="text-sm">{{ $t->plan }}</span><span class="font-bold">{{ Auth::user()->currency }}{{ number_format($t->amount, 2) }}</span></div>
            </div>
            @endforeach
            {{ $t_history->links() }}
        </div>
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
