@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    <h1 class="text-3xl font-bold">Trading History</h1>
    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <table class="w-full">
            <thead><tr class="border-b border-gray-200 dark:border-gray-700">
                <th class="text-left py-3 px-4 text-sm font-medium">Date</th>
                <th class="text-left py-3 px-4 text-sm font-medium">Asset</th>
                <th class="text-left py-3 px-4 text-sm font-medium">Amount</th>
                <th class="text-left py-3 px-4 text-sm font-medium">Type</th>
                <th class="text-left py-3 px-4 text-sm font-medium">Status</th>
            </tr></thead>
            <tbody>
                @foreach($t_history as $trade)
                <tr class="border-b border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50">
                    <td class="py-3 px-4 text-sm">{{ $trade->created_at->format('M d, Y') }}</td>
                    <td class="py-3 px-4 text-sm">{{ $trade->plan }}</td>
                    <td class="py-3 px-4 text-sm font-bold">{{ Auth::user()->currency }}{{ number_format($trade->amount, 2) }}</td>
                    <td class="py-3 px-4 text-sm">{{ $trade->type }}</td>
                    <td class="py-3 px-4"><span class="px-3 py-1 {{ $trade->type == 'WIN' ? 'bg-green-50 text-green-600' : 'bg-red-50 text-red-600' }} text-xs rounded-full">{{ $trade->type }}</span></td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="mt-4">{{ $t_history->links() }}</div>
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
