@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    <h1 class="text-3xl font-bold">Support Center</h1>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div class="rounded-2xl bg-gradient-to-br from-blue-500 to-blue-600 p-8 text-white">
            <i data-lucide="mail" class="w-12 h-12 mb-4"></i>
            <h3 class="text-xl font-bold mb-2">Email Support</h3>
            <p class="mb-4">Get help via email</p>
            <a href="mailto:{{ $settings->contact_email ?? 'support@example.com' }}" class="inline-block px-6 py-3 bg-white text-blue-600 rounded-lg font-medium">Send Email</a>
        </div>
        <div class="rounded-2xl bg-gradient-to-br from-green-500 to-green-600 p-8 text-white">
            <i data-lucide="message-circle" class="w-12 h-12 mb-4"></i>
            <h3 class="text-xl font-bold mb-2">Live Chat</h3>
            <p class="mb-4">Chat with our team</p>
            <button class="px-6 py-3 bg-white text-green-600 rounded-lg font-medium">Start Chat</button>
        </div>
    </div>
    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <h3 class="text-xl font-bold mb-4">Contact Form</h3>
        <form action="{{ route('enquiry') }}" method="POST" class="space-y-4">
            @csrf
            <input type="text" name="name" placeholder="Your Name" class="w-full px-4 py-3 border rounded-xl" required>
            <input type="email" name="email" placeholder="Your Email" class="w-full px-4 py-3 border rounded-xl" required>
            <textarea name="message" placeholder="Your Message" rows="5" class="w-full px-4 py-3 border rounded-xl" required></textarea>
            <button type="submit" class="px-6 py-3 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-bold">Send Message</button>
        </form>
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
