@extends('layouts.modern')
@section('content')
<div class="space-y-6" x-data="{ copied: false }">
    <h1 class="text-3xl font-bold">Referral Program</h1>
    <div class="rounded-2xl bg-gradient-to-r from-purple-600 to-pink-600 p-8 text-white">
        <h2 class="text-2xl font-bold mb-2">Earn {{ $settings->referral_commission ?? 10 }}% Commission</h2>
        <p class="text-purple-100">Invite friends and earn rewards on their investments</p>
    </div>
    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <h3 class="font-bold mb-4">Your Referral Link</h3>
        <div class="flex gap-2">
            <input type="text" value="{{ Auth::user()->ref_link }}" readonly class="flex-1 px-4 py-3 border rounded-xl bg-gray-50">
            <button @click="navigator.clipboard.writeText('{{ Auth::user()->ref_link }}'); copied = true; setTimeout(() => copied = false, 2000)" class="px-6 py-3 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-medium">
                <span x-show="!copied">Copy</span>
                <span x-show="copied">Copied!</span>
            </button>
        </div>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg text-center">
            <div class="text-4xl font-bold text-blue-600 mb-2">{{ Auth::user()->referrals->count() }}</div>
            <div class="text-gray-600">Total Referrals</div>
        </div>
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg text-center">
            <div class="text-4xl font-bold text-green-600 mb-2">{{ Auth::user()->currency }}{{ number_format(Auth::user()->ref_bonus ?? 0, 2) }}</div>
            <div class="text-gray-600">Earned</div>
        </div>
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg text-center">
            <div class="text-4xl font-bold text-purple-600 mb-2">{{ $settings->referral_commission ?? 10 }}%</div>
            <div class="text-gray-600">Commission Rate</div>
        </div>
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
