@extends('layouts.modern')
@section('content')
<div class="space-y-6" x-data="{ activeTab: 'personal' }">
    
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Profile Settings</h1>
            <p class="text-gray-600 dark:text-gray-400 mt-1">Manage your account details and security</p>
        </div>
    </div>

    <div class="bg-gradient-to-r from-blue-600 to-indigo-600 rounded-2xl p-8 text-white">
        <div class="flex items-center gap-4">
            <div class="w-20 h-20 bg-white/20 rounded-full flex items-center justify-center text-3xl font-bold">
                {{ substr(Auth::user()->name, 0, 1) }}
            </div>
            <div>
                <h2 class="text-2xl font-bold">{{ Auth::user()->name }}</h2>
                <p class="text-blue-100">{{ Auth::user()->email }}</p>
            </div>
        </div>
    </div>

    <div class="flex gap-4 border-b border-gray-200 dark:border-gray-700">
        <button @click="activeTab = 'personal'" :class="activeTab === 'personal' ? 'border-b-2 border-blue-600 text-blue-600' : 'text-gray-600'" class="px-4 py-2 font-medium">Personal Info</button>
        <button @click="activeTab = 'security'" :class="activeTab === 'security' ? 'border-b-2 border-blue-600 text-blue-600' : 'text-gray-600'" class="px-4 py-2 font-medium">Security</button>
    </div>

    <div x-show="activeTab === 'personal'" class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        @include('profile.update-profile-information-form')
    </div>

    <div x-show="activeTab === 'security'" class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        @include('profile.update-password-form')
    </div>

</div>
<script>lucide.createIcons();</script>
@endsection
