@extends('layouts.modern')
@section('content')
<div class="space-y-6" x-data="{ copied: false, fileName: '', fileSize: '' }">
    <h1 class="text-3xl font-bold">Complete Deposit</h1>
    
    <div class="rounded-2xl bg-gradient-to-r from-blue-600 to-indigo-600 p-8 text-white text-center">
        <div class="text-sm mb-2">Amount to Deposit</div>
        <div class="text-5xl font-bold mb-2">{{ $amount }}<span class="text-2xl">{{ Auth::user()->currency }}</span></div>
        <div class="text-blue-100">via {{ $payment_mode->name }}</div>
    </div>

    <form method="POST" enctype="multipart/form-data" action="{{ route('savedeposit') }}" class="space-y-6">
        @csrf
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            @if($payment_mode->methodtype == 'crypto')
            <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
                <h3 class="font-bold mb-4">Wallet Address</h3>
                <div class="flex gap-2 mb-4">
                    <input type="text" value="{{ $payment_mode->wallet_address }}" readonly class="flex-1 px-4 py-3 border rounded-xl bg-gray-50 dark:bg-gray-700 text-sm">
                    <button type="button" @click="navigator.clipboard.writeText('{{ $payment_mode->wallet_address }}'); copied = true; setTimeout(() => copied = false, 2000)" class="px-4 py-3 bg-blue-600 text-white rounded-xl">
                        <span x-show="!copied">Copy</span>
                        <span x-show="copied">✓</span>
                    </button>
                </div>
                <img src="https://api.qrserver.com/v1/create-qr-code/?size=250x250&data={{ $payment_mode->wallet_address }}" class="w-64 h-64 mx-auto rounded-xl">
            </div>
            @else
            <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg space-y-4">
                <h3 class="font-bold mb-4">Bank Details</h3>
                <div><label class="text-sm text-gray-600">Bank Name</label><input type="text" value="{{ $payment_mode->bankname }}" readonly class="w-full px-4 py-2 border rounded-xl bg-gray-50 mt-1"></div>
                <div><label class="text-sm text-gray-600">Account Name</label><input type="text" value="{{ $payment_mode->account_name }}" readonly class="w-full px-4 py-2 border rounded-xl bg-gray-50 mt-1"></div>
                <div><label class="text-sm text-gray-600">Account Number</label><input type="text" value="{{ $payment_mode->account_number }}" readonly class="w-full px-4 py-2 border rounded-xl bg-gray-50 mt-1"></div>
            </div>
            @endif

            <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
                <h3 class="font-bold mb-4">Upload Payment Proof</h3>
                <input type="file" id="proof" name="proof" accept="image/*" required class="hidden" @change="fileName = $event.target.files[0]?.name; fileSize = ($event.target.files[0]?.size / 1024 / 1024).toFixed(2) + 'MB'">
                <label for="proof" class="block border-2 border-dashed border-gray-300 rounded-2xl p-8 text-center cursor-pointer hover:border-blue-500">
                    <div x-show="!fileName">
                        <i data-lucide="upload-cloud" class="w-12 h-12 mx-auto mb-4 text-gray-400"></i>
                        <p class="font-medium">Click to upload</p>
                        <p class="text-sm text-gray-500">PNG, JPG up to 10MB</p>
                    </div>
                    <div x-show="fileName">
                        <p class="font-medium" x-text="fileName"></p>
                        <p class="text-sm text-gray-500" x-text="fileSize"></p>
                    </div>
                </label>
            </div>
        </div>

        <input type="hidden" name="amount" value="{{ $amount }}">
        <input type="hidden" name="method" value="{{ $payment_mode->name }}">
        <input type="hidden" name="paymethd_method" value="{{ $payment_mode->name }}">
        @if($asset)<input type="hidden" name="asset" value="{{ $asset }}">@endif

        <button type="submit" :disabled="!fileName" class="w-full py-4 bg-gradient-to-r from-green-600 to-emerald-600 text-white rounded-xl font-bold text-lg disabled:opacity-50">Submit Payment Proof</button>
    </form>
</div>
<script>lucide.createIcons();</script>
@endsection
