@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    <h1 class="text-3xl font-bold">My Portfolio</h1>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($plans as $plan)
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <div class="flex justify-between items-start mb-4">
                <h3 class="font-bold text-lg">{{ $plan->uplan->name ?? 'Investment' }}</h3>
                <span class="px-3 py-1 {{ $plan->active == 'yes' ? 'bg-green-50 text-green-600' : 'bg-gray-50 text-gray-600' }} text-xs rounded-full">{{ $plan->active }}</span>
            </div>
            <div class="space-y-2">
                <div class="flex justify-between"><span class="text-sm text-gray-600">Amount</span><span class="font-bold">{{ $settings->s_currency }}{{ number_format($plan->amount, 2) }}</span></div>
                <div class="flex justify-between"><span class="text-sm text-gray-600">ROI</span><span class="font-bold text-green-600">{{ $settings->s_currency }}{{ number_format($plan->roi, 2) }}</span></div>
                <div class="flex justify-between"><span class="text-sm text-gray-600">Started</span><span class="text-sm">{{ $plan->created_at->format('M d, Y') }}</span></div>
            </div>
        </div>
        @endforeach
    </div>
    <div class="mt-4">{{ $plans->links() }}</div>
</div>
<script>lucide.createIcons();</script>
@endsection
