@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    
    <!-- Page Header -->
    <div class="text-center mb-8">
        <h1 class="text-4xl font-bold text-gray-900 dark:text-white mb-2">Investment Plans</h1>
        <p class="text-gray-600 dark:text-gray-400">Choose the perfect plan to grow your wealth</p>
    </div>

    <!-- Investment Plans Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        @foreach($plans as $plan)
        <div class="group relative overflow-hidden rounded-3xl bg-gradient-to-br {{ $loop->index % 3 == 0 ? 'from-blue-500 to-blue-600' : ($loop->index % 3 == 1 ? 'from-purple-500 to-purple-600' : 'from-emerald-500 to-emerald-600') }} p-8 text-white shadow-2xl hover:scale-105 transition-all duration-300">
            
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <svg class="w-full h-full" viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
                    <path fill="currentColor" d="M45.7,-76.2C58.9,-69.3,69.2,-56.9,75.6,-42.8C82,-28.7,84.5,-12.9,83.4,2.5C82.3,17.9,77.6,32.9,69.4,45.7C61.2,58.5,49.5,69.1,36.1,75.8C22.7,82.5,7.6,85.3,-7.8,85.1C-23.2,84.9,-39,81.7,-52.4,74.4C-65.8,67.1,-76.8,55.7,-83.5,42.2C-90.2,28.7,-92.6,13.1,-91.4,-2.3C-90.2,-17.7,-85.4,-32.9,-76.9,-45.7C-68.4,-58.5,-56.2,-68.9,-42.5,-75.5C-28.8,-82.1,-14.4,-84.9,0.5,-85.8C15.4,-86.7,32.5,-83.1,45.7,-76.2Z" transform="translate(100 100)" />
                </svg>
            </div>

            <div class="relative z-10">
                <!-- Plan Badge -->
                @if($loop->index % 3 == 2)
                <div class="absolute -top-4 -right-4 px-4 py-2 bg-yellow-400 text-yellow-900 rounded-full text-xs font-bold shadow-lg">
                    POPULAR
                </div>
                @endif

                <!-- Plan Icon -->
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-6">
                    <i data-lucide="trending-up" class="w-8 h-8"></i>
                </div>

                <!-- Plan Name -->
                <h3 class="text-2xl font-bold mb-2">{{ $plan->name }}</h3>
                
                <!-- ROI -->
                <div class="mb-6">
                    <div class="text-5xl font-bold mb-1">{{ $plan->increment_amount }}%</div>
                    <div class="text-white/80">{{ $plan->increment_type }} Returns</div>
                </div>

                <!-- Plan Details -->
                <div class="space-y-3 mb-6">
                    <div class="flex items-center gap-2">
                        <i data-lucide="check-circle" class="w-5 h-5"></i>
                        <span>Min: {{ $settings->s_currency }}{{ number_format($plan->price, 2) }}</span>
                    </div>
                    <div class="flex items-center gap-2">
                        <i data-lucide="check-circle" class="w-5 h-5"></i>
                        <span>Max: {{ $settings->s_currency }}{{ number_format($plan->maximum_price, 2) }}</span>
                    </div>
                    <div class="flex items-center gap-2">
                        <i data-lucide="check-circle" class="w-5 h-5"></i>
                        <span>Duration: {{ $plan->increment_interval }}</span>
                    </div>
                    @if($plan->gift_bonus > 0)
                    <div class="flex items-center gap-2">
                        <i data-lucide="gift" class="w-5 h-5"></i>
                        <span>Bonus: {{ $plan->gift_bonus }}%</span>
                    </div>
                    @endif
                </div>

                <!-- Invest Button -->
                <button onclick="openInvestModal('{{ $plan->id }}', '{{ $plan->name }}', '{{ $plan->price }}', '{{ $plan->maximum_price }}')" 
                        class="w-full py-4 bg-white text-gray-900 rounded-xl font-bold hover:bg-gray-100 transition-all shadow-lg">
                    Invest Now
                </button>
            </div>
        </div>
        @endforeach
    </div>

    <!-- Investment Modal -->
    <div id="investModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 max-w-md w-full shadow-2xl">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-2xl font-bold">Invest in <span id="modalPlanName"></span></h3>
                <button onclick="closeInvestModal()" class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg">
                    <i data-lucide="x" class="w-5 h-5"></i>
                </button>
            </div>

            <form action="{{ route('joininvestmentplan') }}" method="POST" class="space-y-4">
                @csrf
                <input type="hidden" name="plan_id" id="modalPlanId">
                
                <div>
                    <label class="block text-sm font-medium mb-2">Investment Amount</label>
                    <div class="relative">
                        <span class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-500">{{ $settings->s_currency }}</span>
                        <input type="number" name="amount" id="investAmount" 
                               class="w-full pl-12 pr-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-blue-500 dark:bg-gray-700" 
                               placeholder="0.00" required>
                    </div>
                    <p class="text-xs text-gray-500 mt-1">Min: <span id="modalMinAmount"></span> - Max: <span id="modalMaxAmount"></span></p>
                </div>

                <button type="submit" class="w-full py-3 bg-gradient-to-r from-blue-600 to-indigo-600 text-white rounded-xl font-bold hover:shadow-lg transition-all">
                    Confirm Investment
                </button>
            </form>
        </div>
    </div>

</div>

<script>
    lucide.createIcons();

    function openInvestModal(planId, planName, minAmount, maxAmount) {
        document.getElementById('investModal').classList.remove('hidden');
        document.getElementById('investModal').classList.add('flex');
        document.getElementById('modalPlanId').value = planId;
        document.getElementById('modalPlanName').textContent = planName;
        document.getElementById('modalMinAmount').textContent = '{{ $settings->s_currency }}' + parseFloat(minAmount).toLocaleString();
        document.getElementById('modalMaxAmount').textContent = '{{ $settings->s_currency }}' + parseFloat(maxAmount).toLocaleString();
        lucide.createIcons();
    }

    function closeInvestModal() {
        document.getElementById('investModal').classList.add('hidden');
        document.getElementById('investModal').classList.remove('flex');
    }
</script>
@endsection
