@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    
    <!-- Welcome Header -->
    <div class="relative overflow-hidden rounded-2xl bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 p-8 text-white">
        <div class="absolute inset-0 bg-black/10"></div>
        <div class="relative z-10">
            <h1 class="text-3xl font-bold mb-2">Welcome back, {{ Auth::user()->name }}! 👋</h1>
            <p class="text-blue-100">Here's what's happening with your investments today</p>
        </div>
        <div class="absolute right-0 top-0 opacity-20">
            <svg class="w-64 h-64" viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
                <path fill="currentColor" d="M45.7,-76.2C58.9,-69.3,69.2,-56.9,75.6,-42.8C82,-28.7,84.5,-12.9,83.4,2.5C82.3,17.9,77.6,32.9,69.4,45.7C61.2,58.5,49.5,69.1,36.1,75.8C22.7,82.5,7.6,85.3,-7.8,85.1C-23.2,84.9,-39,81.7,-52.4,74.4C-65.8,67.1,-76.8,55.7,-83.5,42.2C-90.2,28.7,-92.6,13.1,-91.4,-2.3C-90.2,-17.7,-85.4,-32.9,-76.9,-45.7C-68.4,-58.5,-56.2,-68.9,-42.5,-75.5C-28.8,-82.1,-14.4,-84.9,0.5,-85.8C15.4,-86.7,32.5,-83.1,45.7,-76.2Z" transform="translate(100 100)" />
            </svg>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Account Balance -->
        <div class="group relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg hover:shadow-xl transition-all">
            <div class="absolute inset-0 bg-gradient-to-br from-blue-500/5 to-indigo-500/5"></div>
            <div class="relative">
                <div class="flex items-center justify-between mb-4">
                    <div class="p-3 bg-blue-500/10 rounded-xl">
                        <i data-lucide="wallet" class="w-6 h-6 text-blue-600"></i>
                    </div>
                    <span class="text-xs font-medium text-green-600 bg-green-50 px-2 py-1 rounded-full">Active</span>
                </div>
                <h3 class="text-sm text-gray-600 dark:text-gray-400 mb-1">Account Balance</h3>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ Auth::user()->currency }}{{ number_format(Auth::user()->account_bal, 2) }}</p>
            </div>
        </div>

        <!-- Total Profit -->
        <div class="group relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg hover:shadow-xl transition-all">
            <div class="absolute inset-0 bg-gradient-to-br from-emerald-500/5 to-green-500/5"></div>
            <div class="relative">
                <div class="flex items-center justify-between mb-4">
                    <div class="p-3 bg-emerald-500/10 rounded-xl">
                        <i data-lucide="trending-up" class="w-6 h-6 text-emerald-600"></i>
                    </div>
                    <span class="text-xs font-medium text-emerald-600 bg-emerald-50 px-2 py-1 rounded-full">+12.5%</span>
                </div>
                <h3 class="text-sm text-gray-600 dark:text-gray-400 mb-1">Total Profit</h3>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ Auth::user()->currency }}{{ number_format(Auth::user()->roi, 2) }}</p>
            </div>
        </div>

        <!-- Total Deposit -->
        <div class="group relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg hover:shadow-xl transition-all">
            <div class="absolute inset-0 bg-gradient-to-br from-purple-500/5 to-pink-500/5"></div>
            <div class="relative">
                <div class="flex items-center justify-between mb-4">
                    <div class="p-3 bg-purple-500/10 rounded-xl">
                        <i data-lucide="arrow-down-circle" class="w-6 h-6 text-purple-600"></i>
                    </div>
                </div>
                <h3 class="text-sm text-gray-600 dark:text-gray-400 mb-1">Total Deposit</h3>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ Auth::user()->currency }}{{ number_format($deposited, 2) }}</p>
            </div>
        </div>

        <!-- Total Withdrawal -->
        <div class="group relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg hover:shadow-xl transition-all">
            <div class="absolute inset-0 bg-gradient-to-br from-orange-500/5 to-red-500/5"></div>
            <div class="relative">
                <div class="flex items-center justify-between mb-4">
                    <div class="p-3 bg-orange-500/10 rounded-xl">
                        <i data-lucide="arrow-up-circle" class="w-6 h-6 text-orange-600"></i>
                    </div>
                </div>
                <h3 class="text-sm text-gray-600 dark:text-gray-400 mb-1">Total Withdrawal</h3>
                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ Auth::user()->currency }}{{ number_format($total_withdrawal, 2) }}</p>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
        <a href="{{ route('deposits') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-blue-500 to-blue-600 p-6 text-white hover:shadow-2xl transition-all">
            <i data-lucide="plus-circle" class="w-8 h-8 mb-3"></i>
            <h3 class="font-semibold">Deposit</h3>
            <p class="text-xs text-blue-100 mt-1">Add funds</p>
        </a>
        
        <a href="{{ route('withdrawalsdeposits') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-emerald-500 to-emerald-600 p-6 text-white hover:shadow-2xl transition-all">
            <i data-lucide="arrow-up-right" class="w-8 h-8 mb-3"></i>
            <h3 class="font-semibold">Withdraw</h3>
            <p class="text-xs text-emerald-100 mt-1">Cash out</p>
        </a>
        
        <a href="{{ route('mplans') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-purple-500 to-purple-600 p-6 text-white hover:shadow-2xl transition-all">
            <i data-lucide="trending-up" class="w-8 h-8 mb-3"></i>
            <h3 class="font-semibold">Invest</h3>
            <p class="text-xs text-purple-100 mt-1">Start earning</p>
        </a>
        
        <a href="{{ route('demo.dashboard') }}" class="group relative overflow-hidden rounded-xl bg-gradient-to-br from-orange-500 to-orange-600 p-6 text-white hover:shadow-2xl transition-all">
            <i data-lucide="graduation-cap" class="w-8 h-8 mb-3"></i>
            <h3 class="font-semibold">Demo</h3>
            <p class="text-xs text-orange-100 mt-1">Practice free</p>
        </a>
    </div>

    <!-- Chart & Recent Activity -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Trading Chart -->
        <div class="lg:col-span-2 rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <h3 class="text-lg font-bold mb-4">Market Overview</h3>
            <div id="tradingview_chart" style="height: 400px;"></div>
            <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
            <script>
                new TradingView.widget({
                    autosize: true,
                    symbol: "BINANCE:BTCUSDT",
                    interval: "D",
                    timezone: "Etc/UTC",
                    theme: "light",
                    style: "1",
                    locale: "en",
                    toolbar_bg: "#f1f3f6",
                    enable_publishing: false,
                    allow_symbol_change: true,
                    container_id: "tradingview_chart"
                });
            </script>
        </div>

        <!-- Recent Trades -->
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <h3 class="text-lg font-bold mb-4">Recent Trades</h3>
            <div class="space-y-3">
                @foreach($t_history->take(5) as $trade)
                <div class="flex items-center justify-between p-3 rounded-xl {{ $trade->type == 'WIN' ? 'bg-emerald-50 dark:bg-emerald-900/20' : 'bg-red-50 dark:bg-red-900/20' }}">
                    <div class="flex items-center gap-3">
                        <div class="p-2 rounded-lg {{ $trade->type == 'WIN' ? 'bg-emerald-500' : 'bg-red-500' }}">
                            <i data-lucide="{{ $trade->type == 'WIN' ? 'trending-up' : 'trending-down' }}" class="w-4 h-4 text-white"></i>
                        </div>
                        <div>
                            <p class="font-medium text-sm">{{ $trade->plan }}</p>
                            <p class="text-xs text-gray-500">{{ $trade->created_at->diffForHumans() }}</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="font-bold {{ $trade->type == 'WIN' ? 'text-emerald-600' : 'text-red-600' }}">
                            {{ $trade->type == 'WIN' ? '+' : '-' }}{{ Auth::user()->currency }}{{ number_format($trade->amount, 2) }}
                        </p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Investment Plans Preview -->
    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold">Investment Plans</h3>
            <a href="{{ route('mplans') }}" class="text-blue-600 hover:text-blue-700 text-sm font-medium">View All →</a>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="relative overflow-hidden rounded-xl bg-gradient-to-br from-blue-500 to-blue-600 p-6 text-white">
                <h4 class="text-xl font-bold mb-2">Starter</h4>
                <p class="text-3xl font-bold mb-4">5% <span class="text-sm">Daily</span></p>
                <p class="text-blue-100 text-sm mb-4">Min: $100 - Max: $999</p>
                <a href="{{ route('mplans') }}" class="inline-block px-4 py-2 bg-white text-blue-600 rounded-lg font-medium hover:bg-blue-50">Invest Now</a>
            </div>
            
            <div class="relative overflow-hidden rounded-xl bg-gradient-to-br from-purple-500 to-purple-600 p-6 text-white">
                <h4 class="text-xl font-bold mb-2">Professional</h4>
                <p class="text-3xl font-bold mb-4">10% <span class="text-sm">Daily</span></p>
                <p class="text-purple-100 text-sm mb-4">Min: $1,000 - Max: $4,999</p>
                <a href="{{ route('mplans') }}" class="inline-block px-4 py-2 bg-white text-purple-600 rounded-lg font-medium hover:bg-purple-50">Invest Now</a>
            </div>
            
            <div class="relative overflow-hidden rounded-xl bg-gradient-to-br from-emerald-500 to-emerald-600 p-6 text-white">
                <h4 class="text-xl font-bold mb-2">Premium</h4>
                <p class="text-3xl font-bold mb-4">15% <span class="text-sm">Daily</span></p>
                <p class="text-emerald-100 text-sm mb-4">Min: $5,000+</p>
                <a href="{{ route('mplans') }}" class="inline-block px-4 py-2 bg-white text-emerald-600 rounded-lg font-medium hover:bg-emerald-50">Invest Now</a>
            </div>
        </div>
    </div>

</div>

<script>
    lucide.createIcons();
</script>
@endsection
