@extends('layouts.modern')
@section('content')
<div class="space-y-6" x-data="{ amount: {{ $bot->min_investment }} }">
    <h1 class="text-3xl font-bold">{{ $bot->name }}</h1>
    
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 space-y-6">
            <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
                <h3 class="font-bold mb-4">Bot Details</h3>
                <p class="text-gray-600 dark:text-gray-400 mb-4">{{ $bot->description }}</p>
                <div class="grid grid-cols-2 gap-4">
                    <div><div class="text-sm text-gray-600">Success Rate</div><div class="text-2xl font-bold text-green-600">{{ $botStats['success_rate'] }}%</div></div>
                    <div><div class="text-sm text-gray-600">Total Trades</div><div class="text-2xl font-bold">{{ $botStats['total_trades'] }}</div></div>
                    <div><div class="text-sm text-gray-600">Daily Profit</div><div class="text-2xl font-bold text-green-600">{{ $bot->daily_profit_min }}-{{ $bot->daily_profit_max }}%</div></div>
                    <div><div class="text-sm text-gray-600">Active Users</div><div class="text-2xl font-bold">{{ $botStats['total_users'] }}</div></div>
                </div>
            </div>
        </div>

        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <h3 class="font-bold mb-4">Invest in Bot</h3>
            @if($userInvestment)
            <div class="text-center py-8">
                <div class="text-green-600 mb-2"><i data-lucide="check-circle" class="w-12 h-12 mx-auto"></i></div>
                <p class="font-bold mb-4">Already Invested</p>
                <a href="{{ route('user.bots.dashboard') }}" class="block w-full py-3 bg-blue-600 text-white rounded-xl text-center font-bold">View Dashboard</a>
            </div>
            @else
            <form action="{{ route('user.bots.invest', $bot->id) }}" method="POST" class="space-y-4">
                @csrf
                <div>
                    <label class="block text-sm font-medium mb-2">Investment Amount</label>
                    <input type="number" name="amount" x-model="amount" min="{{ $bot->min_investment }}" max="{{ $bot->max_investment }}" class="w-full px-4 py-3 border rounded-xl" required>
                    <p class="text-xs text-gray-500 mt-1">Min: {{ Auth::user()->currency }}{{ number_format($bot->min_investment, 2) }} - Max: {{ Auth::user()->currency }}{{ number_format($bot->max_investment, 2) }}</p>
                </div>
                <div class="p-4 bg-blue-50 dark:bg-blue-900/20 rounded-xl">
                    <div class="text-sm mb-2">Expected Daily Profit</div>
                    <div class="text-2xl font-bold text-blue-600" x-text="'{{ Auth::user()->currency }}' + (amount * {{ $bot->daily_profit_min }} / 100).toFixed(2) + ' - ' + '{{ Auth::user()->currency }}' + (amount * {{ $bot->daily_profit_max }} / 100).toFixed(2)"></div>
                </div>
                <button type="submit" class="w-full py-3 bg-gradient-to-r from-purple-600 to-pink-600 text-white rounded-xl font-bold">Invest Now</button>
            </form>
            @endif
        </div>
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
