@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    <h1 class="text-3xl font-bold">AI Trading Bots</h1>
    
    @if($userInvestments->count() > 0)
    <div class="rounded-2xl bg-gradient-to-r from-purple-600 to-pink-600 p-6 text-white">
        <h3 class="text-xl font-bold mb-2">Active Investments</h3>
        <div class="grid grid-cols-3 gap-4">
            <div><div class="text-2xl font-bold">{{ $userInvestments->count() }}</div><div class="text-sm">Active Bots</div></div>
            <div><div class="text-2xl font-bold">{{ Auth::user()->currency }}{{ number_format($userInvestments->sum('investment_amount'), 2) }}</div><div class="text-sm">Total Invested</div></div>
            <div><div class="text-2xl font-bold">{{ Auth::user()->currency }}{{ number_format($userInvestments->sum('total_profit'), 2) }}</div><div class="text-sm">Total Profit</div></div>
        </div>
    </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($bots as $bot)
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-xl font-bold">{{ $bot->name }}</h3>
                <span class="px-3 py-1 bg-green-50 text-green-600 text-xs rounded-full">{{ $bot->success_rate }}% Win</span>
            </div>
            <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">{{ $bot->description }}</p>
            <div class="space-y-2 mb-4">
                <div class="flex justify-between text-sm"><span>Daily Profit</span><span class="font-bold text-green-600">{{ $bot->daily_profit_min }}-{{ $bot->daily_profit_max }}%</span></div>
                <div class="flex justify-between text-sm"><span>Min Investment</span><span class="font-bold">{{ Auth::user()->currency }}{{ number_format($bot->min_investment, 2) }}</span></div>
                <div class="flex justify-between text-sm"><span>Duration</span><span class="font-bold">{{ $bot->duration_days }} days</span></div>
            </div>
            <a href="{{ route('user.bots.show', $bot->id) }}" class="block w-full py-3 bg-gradient-to-r from-purple-600 to-pink-600 text-white rounded-xl text-center font-bold">Invest Now</a>
        </div>
        @endforeach
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
