@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    <h1 class="text-3xl font-bold">Trading History - {{ $investment->bot->name }}</h1>
    
    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <table class="w-full">
            <thead><tr class="border-b"><th class="text-left py-3 px-4">Date</th><th class="text-left py-3 px-4">Pair</th><th class="text-left py-3 px-4">Type</th><th class="text-left py-3 px-4">Amount</th><th class="text-left py-3 px-4">Result</th></tr></thead>
            <tbody>
                @foreach($trades as $trade)
                <tr class="border-b hover:bg-gray-50 dark:hover:bg-gray-700/50">
                    <td class="py-3 px-4 text-sm">{{ $trade->opened_at->format('M d, Y H:i') }}</td>
                    <td class="py-3 px-4 text-sm">{{ $trade->trading_pair }}</td>
                    <td class="py-3 px-4 text-sm">{{ $trade->trade_type }}</td>
                    <td class="py-3 px-4 text-sm font-bold">{{ Auth::user()->currency }}{{ number_format($trade->amount, 2) }}</td>
                    <td class="py-3 px-4"><span class="px-3 py-1 {{ $trade->result == 'profit' ? 'bg-green-50 text-green-600' : 'bg-red-50 text-red-600' }} text-xs rounded-full">{{ $trade->result == 'profit' ? '+' : '-' }}{{ Auth::user()->currency }}{{ number_format(abs($trade->profit_loss), 2) }}</span></td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="mt-4">{{ $trades->links() }}</div>
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
