@extends('layouts.modern')
@section('content')
<div class="space-y-6">
    <h1 class="text-3xl font-bold">Bot Trading Dashboard</h1>
    
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg"><div class="text-sm text-gray-600 mb-2">Total Invested</div><div class="text-2xl font-bold">{{ Auth::user()->currency }}{{ number_format($stats['total_invested'], 2) }}</div></div>
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg"><div class="text-sm text-gray-600 mb-2">Current Balance</div><div class="text-2xl font-bold text-blue-600">{{ Auth::user()->currency }}{{ number_format($stats['current_balance'], 2) }}</div></div>
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg"><div class="text-sm text-gray-600 mb-2">Total Profit</div><div class="text-2xl font-bold text-green-600">{{ Auth::user()->currency }}{{ number_format($stats['total_profit'], 2) }}</div></div>
        <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg"><div class="text-sm text-gray-600 mb-2">Active Bots</div><div class="text-2xl font-bold">{{ $stats['active_bots'] }}</div></div>
    </div>

    <div class="rounded-2xl bg-white dark:bg-gray-800 p-6 shadow-lg">
        <h3 class="font-bold mb-4">My Bot Investments</h3>
        <div class="space-y-4">
            @forelse($investments as $inv)
            <div class="p-4 border rounded-xl">
                <div class="flex items-center justify-between mb-2">
                    <h4 class="font-bold">{{ $inv->bot->name }}</h4>
                    <span class="px-3 py-1 {{ $inv->status == 'active' ? 'bg-green-50 text-green-600' : 'bg-gray-50 text-gray-600' }} text-xs rounded-full">{{ ucfirst($inv->status) }}</span>
                </div>
                <div class="grid grid-cols-4 gap-4 text-sm">
                    <div><span class="text-gray-600">Invested</span><div class="font-bold">{{ Auth::user()->currency }}{{ number_format($inv->investment_amount, 2) }}</div></div>
                    <div><span class="text-gray-600">Current</span><div class="font-bold text-blue-600">{{ Auth::user()->currency }}{{ number_format($inv->current_balance, 2) }}</div></div>
                    <div><span class="text-gray-600">Profit</span><div class="font-bold text-green-600">{{ Auth::user()->currency }}{{ number_format($inv->total_profit, 2) }}</div></div>
                    <div><span class="text-gray-600">ROI</span><div class="font-bold">{{ number_format($inv->roi_percentage, 2) }}%</div></div>
                </div>
                @if($inv->status == 'active')
                <form action="{{ route('user.bots.cancel', $inv->id) }}" method="POST" class="mt-4">
                    @csrf
                    <button type="submit" onclick="return confirm('Cancel this investment?')" class="px-4 py-2 bg-red-600 text-white rounded-lg text-sm">Cancel Investment</button>
                </form>
                @endif
            </div>
            @empty
            <p class="text-center text-gray-500 py-8">No investments yet</p>
            @endforelse
        </div>
    </div>
</div>
<script>lucide.createIcons();</script>
@endsection
