<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex h-screen bg-slate-50">
    
    <!-- Mobile Sidebar Overlay -->
    <div id="sidebarOverlay" class="fixed inset-0 bg-slate-900/50 z-20 lg:hidden hidden" onclick="toggleSidebar()"></div>

    <!-- Sidebar -->
    <aside id="sidebar" class="fixed lg:static inset-y-0 left-0 z-30 w-64 bg-white border-r border-slate-200 transform -translate-x-full lg:translate-x-0 transition-transform duration-200 flex flex-col">
        <!-- Logo -->
        <div class="h-16 flex items-center px-6 border-b border-slate-200">
            <div class="w-8 h-8 bg-green-600 rounded-lg flex items-center justify-center mr-3">
                <i class="fas fa-chart-line text-white text-sm"></i>
            </div>
            <span class="text-xl font-bold text-green-600"><?php echo e($settings->site_name); ?></span>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 px-4 py-6 space-y-1 overflow-y-auto">
            <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg bg-green-50 text-green-600">
                <i class="fas fa-th-large w-5 mr-3"></i> Dashboard
            </a>
            <a href="#" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg text-slate-600 hover:bg-slate-50 transition-colors">
                <i class="fas fa-chart-pie w-5 mr-3"></i> Portfolio
            </a>
            <a href="#" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg text-slate-600 hover:bg-slate-50 transition-colors">
                <i class="fas fa-wallet w-5 mr-3"></i> Holdings
            </a>
            <a href="#" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg text-slate-600 hover:bg-slate-50 transition-colors">
                <i class="fas fa-chart-bar w-5 mr-3"></i> Analytics
            </a>
            <a href="#" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg text-slate-600 hover:bg-slate-50 transition-colors">
                <i class="fas fa-exchange-alt w-5 mr-3"></i> Transactions
            </a>
            <a href="#" class="flex items-center px-4 py-3 text-sm font-medium rounded-lg text-slate-600 hover:bg-slate-50 transition-colors">
                <i class="fas fa-cog w-5 mr-3"></i> Settings
            </a>
        </nav>

        <!-- User Profile -->
        <div class="p-4 border-t border-slate-200">
            <div class="flex items-center">
                <img src="https://ui-avatars.com/api/?name=<?php echo e(Auth::user()->name); ?>&background=10b981&color=fff" class="h-10 w-10 rounded-full">
                <div class="ml-3 flex-1 min-w-0">
                    <p class="text-sm font-medium text-slate-900 truncate"><?php echo e(Auth::user()->name); ?></p>
                    <p class="text-xs text-slate-500 truncate">Premium Investor</p>
                </div>
            </div>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 flex flex-col min-w-0 bg-slate-50">
        
        <!-- Header -->
        <header class="h-16 flex items-center justify-between px-6 bg-white border-b border-slate-200 shadow-sm z-10">
            <button onclick="toggleSidebar()" class="lg:hidden p-2 -ml-2 text-slate-500 hover:text-slate-700">
                <i class="fas fa-bars text-lg"></i>
            </button>

            <div class="flex-1 max-w-xl ml-4 lg:ml-0">
                <div class="relative">
                    <i class="fas fa-search absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                    <input type="text" placeholder="Search assets, symbols, or transactions..." 
                        class="w-full pl-10 pr-4 py-2 bg-slate-50 border border-slate-200 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent transition-all">
                </div>
            </div>

            <div class="flex items-center gap-3 ml-4">
                <button class="relative p-2 text-slate-500 hover:text-slate-700 transition-colors">
                    <i class="fas fa-bell"></i>
                    <span class="absolute top-1.5 right-1.5 w-2 h-2 bg-green-500 rounded-full border-2 border-white"></span>
                </button>
            </div>
        </header>

        <!-- Scrollable Dashboard Content -->
        <div class="flex-1 overflow-y-auto p-4 md:p-6 space-y-6">
            
            <!-- Title & Actions -->
            <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                <div>
                    <h1 class="text-2xl font-bold text-slate-900">Dashboard Overview</h1>
                    <p class="text-slate-500 text-sm mt-1">Welcome back, here's your portfolio performance.</p>
                </div>
                <button class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-lg shadow-sm transition-all inline-flex items-center justify-center">
                    <i class="fas fa-plus w-4 h-4 mr-2"></i>
                    Deposit Funds
                </button>
            </div>

            <!-- Metrics Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Card 1 -->
                <div class="bg-white p-6 rounded-lg border border-slate-200 shadow-sm hover:shadow-md transition-shadow">
                    <div class="flex justify-between items-start mb-4">
                        <div class="p-2 bg-green-50 rounded-lg">
                            <i class="fas fa-wallet text-green-600"></i>
                        </div>
                        <div class="flex items-center text-sm font-medium text-green-600">
                            <i class="fas fa-arrow-up text-xs mr-1"></i>
                            12.5%
                        </div>
                    </div>
                    <h3 class="text-slate-500 text-sm font-medium">Total Balance</h3>
                    <p class="text-2xl font-bold text-slate-900 mt-1">$<?php echo e(number_format(Auth::user()->balance, 2)); ?></p>
                </div>

                <!-- Card 2 -->
                <div class="bg-white p-6 rounded-lg border border-slate-200 shadow-sm hover:shadow-md transition-shadow">
                    <div class="flex justify-between items-start mb-4">
                        <div class="p-2 bg-blue-50 rounded-lg">
                            <i class="fas fa-chart-line text-blue-600"></i>
                        </div>
                        <div class="flex items-center text-sm font-medium text-green-600">
                            <i class="fas fa-arrow-up text-xs mr-1"></i>
                            2.4%
                        </div>
                    </div>
                    <h3 class="text-slate-500 text-sm font-medium">Daily Profit/Loss</h3>
                    <p class="text-2xl font-bold text-slate-900 mt-1">+$<?php echo e(number_format(Auth::user()->profit ?? 1240.50, 2)); ?></p>
                </div>

                <!-- Card 3 -->
                <div class="bg-white p-6 rounded-lg border border-slate-200 shadow-sm hover:shadow-md transition-shadow">
                    <div class="flex justify-between items-start mb-4">
                        <div class="p-2 bg-purple-50 rounded-lg">
                            <i class="fas fa-chart-pie text-purple-600"></i>
                        </div>
                        <div class="flex items-center text-sm font-medium text-green-600">
                            <i class="fas fa-arrow-up text-xs mr-1"></i>
                            5.2%
                        </div>
                    </div>
                    <h3 class="text-slate-500 text-sm font-medium">Total Invested</h3>
                    <p class="text-2xl font-bold text-slate-900 mt-1">$<?php echo e(number_format(Auth::user()->invested ?? 145000, 2)); ?></p>
                </div>

                <!-- Card 4 -->
                <div class="bg-white p-6 rounded-lg border border-slate-200 shadow-sm hover:shadow-md transition-shadow">
                    <div class="flex justify-between items-start mb-4">
                        <div class="p-2 bg-amber-50 rounded-lg">
                            <i class="fas fa-dollar-sign text-amber-600"></i>
                        </div>
                        <div class="flex items-center text-sm font-medium text-slate-500">
                            <i class="fas fa-minus text-xs mr-1"></i>
                            0%
                        </div>
                    </div>
                    <h3 class="text-slate-500 text-sm font-medium">Available Cash</h3>
                    <p class="text-2xl font-bold text-slate-900 mt-1">$<?php echo e(number_format(Auth::user()->bonus ?? 29520.45, 2)); ?></p>
                </div>
            </div>

            <!-- Charts Section -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                
                <!-- Area Chart -->
                <div class="lg:col-span-2 bg-white rounded-lg border border-slate-200 p-6 shadow-sm">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="font-semibold text-slate-900">Portfolio Growth</h3>
                        <!-- Time Toggle -->
                        <div class="flex bg-slate-100 rounded-lg p-1">
                            <button class="px-3 py-1 text-xs font-medium rounded-md text-slate-500 hover:text-slate-900 transition-colors">1M</button>
                            <button class="px-3 py-1 text-xs font-medium rounded-md text-slate-500 hover:text-slate-900 transition-colors">6M</button>
                            <button class="px-3 py-1 text-xs font-medium rounded-md bg-white text-green-600 shadow-sm">1Y</button>
                            <button class="px-3 py-1 text-xs font-medium rounded-md text-slate-500 hover:text-slate-900 transition-colors">ALL</button>
                        </div>
                    </div>
                    <div id="growthChart" class="w-full h-[300px]"></div>
                </div>

                <!-- Donut Chart -->
                <div class="bg-white rounded-lg border border-slate-200 p-6 shadow-sm flex flex-col">
                    <h3 class="font-semibold text-slate-900 mb-2">Asset Allocation</h3>
                    <div class="flex-1 flex items-center justify-center relative">
                        <div id="allocationChart" class="w-full flex justify-center"></div>
                    </div>
                    <!-- Custom Legend -->
                    <div class="mt-4 space-y-3">
                        <div class="flex items-center justify-between text-sm">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full mr-2 bg-green-500"></div>
                                <span class="text-slate-600">Technology</span>
                            </div>
                            <span class="font-medium text-slate-900">45%</span>
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full mr-2 bg-purple-500"></div>
                                <span class="text-slate-600">Real Estate</span>
                            </div>
                            <span class="font-medium text-slate-900">20%</span>
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full mr-2 bg-amber-500"></div>
                                <span class="text-slate-600">Crypto</span>
                            </div>
                            <span class="font-medium text-slate-900">15%</span>
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full mr-2 bg-blue-500"></div>
                                <span class="text-slate-600">Bonds</span>
                            </div>
                            <span class="font-medium text-slate-900">10%</span>
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full mr-2 bg-slate-400"></div>
                                <span class="text-slate-600">Cash</span>
                            </div>
                            <span class="font-medium text-slate-900">10%</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom Row -->
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 pb-6">
                
                <!-- Holdings Table -->
                <div class="lg:col-span-2 bg-white rounded-lg border border-slate-200 shadow-sm overflow-hidden">
                    <div class="p-6 border-b border-slate-200 flex justify-between items-center">
                        <h3 class="font-semibold text-slate-900">Top Holdings</h3>
                        <button class="text-sm text-green-600 hover:text-green-700 font-medium">View All</button>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <thead class="bg-slate-50">
                                <tr>
                                    <th class="px-6 py-3 text-xs font-semibold text-slate-500 uppercase tracking-wider">Asset</th>
                                    <th class="px-6 py-3 text-xs font-semibold text-slate-500 uppercase tracking-wider">Price</th>
                                    <th class="px-6 py-3 text-xs font-semibold text-slate-500 uppercase tracking-wider">Balance</th>
                                    <th class="px-6 py-3 text-xs font-semibold text-slate-500 uppercase tracking-wider text-right">24h Change</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-200">
                                <!-- Row 1 -->
                                <tr class="hover:bg-slate-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="h-8 w-8 rounded-full bg-slate-100 flex items-center justify-center font-bold text-xs text-slate-600 mr-3">A</div>
                                            <div>
                                                <div class="font-medium text-slate-900">AAPL</div>
                                                <div class="text-xs text-slate-500">Apple Inc.</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600">$189.45</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600">
                                        <div class="text-slate-900 font-medium">$28,417.50</div>
                                        <div class="text-xs text-slate-500">150 Shares</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-50 text-green-700">
                                            +1.25%
                                        </span>
                                    </td>
                                </tr>
                                <!-- Row 2 -->
                                <tr class="hover:bg-slate-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="h-8 w-8 rounded-full bg-slate-100 flex items-center justify-center font-bold text-xs text-slate-600 mr-3">B</div>
                                            <div>
                                                <div class="font-medium text-slate-900">BTC</div>
                                                <div class="text-xs text-slate-500">Bitcoin</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600">$64,230.10</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600">
                                        <div class="text-slate-900 font-medium">$28,903.54</div>
                                        <div class="text-xs text-slate-500">0.45 Shares</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-50 text-red-700">
                                            -2.4%
                                        </span>
                                    </td>
                                </tr>
                                <!-- Row 3 -->
                                <tr class="hover:bg-slate-50 transition-colors">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="flex items-center">
                                            <div class="h-8 w-8 rounded-full bg-slate-100 flex items-center justify-center font-bold text-xs text-slate-600 mr-3">T</div>
                                            <div>
                                                <div class="font-medium text-slate-900">TSLA</div>
                                                <div class="text-xs text-slate-500">Tesla, Inc.</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600">$210.50</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-600">
                                        <div class="text-slate-900 font-medium">$16,840.00</div>
                                        <div class="text-xs text-slate-500">80 Shares</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-50 text-green-700">
                                            +3.10%
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="bg-white rounded-lg border border-slate-200 shadow-sm p-6">
                    <h3 class="font-semibold text-slate-900 mb-6">Recent Activity</h3>
                    <div class="space-y-6">
                        
                        <!-- Item 1 -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="p-2 rounded-lg mr-3 bg-green-50 text-green-600">
                                    <i class="fas fa-arrow-down text-sm"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-slate-900">Buy AAPL</p>
                                    <p class="text-xs text-slate-500">Today, 10:23 AM</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-medium text-slate-900">-$2,500.00</p>
                                <p class="text-xs text-slate-500">Completed</p>
                            </div>
                        </div>

                        <!-- Item 2 -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="p-2 rounded-lg mr-3 bg-red-50 text-red-600">
                                    <i class="fas fa-arrow-up text-sm"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-slate-900">Sell ETH</p>
                                    <p class="text-xs text-slate-500">Yesterday, 2:15 PM</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-medium text-green-600">+$1,200.00</p>
                                <p class="text-xs text-slate-500">Completed</p>
                            </div>
                        </div>

                        <!-- Item 3 -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="p-2 rounded-lg mr-3 bg-blue-50 text-blue-600">
                                    <i class="fas fa-dollar-sign text-sm"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-slate-900">Dividend</p>
                                    <p class="text-xs text-slate-500">Dec 01, 2023</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-medium text-green-600">+$450.20</p>
                                <p class="text-xs text-slate-500">Received</p>
                            </div>
                        </div>

                        <!-- Item 4 -->
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <div class="p-2 rounded-lg mr-3 bg-purple-50 text-purple-600">
                                    <i class="fas fa-exchange-alt text-sm"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-slate-900">Transfer</p>
                                    <p class="text-xs text-slate-500">Nov 28, 2023</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-medium text-slate-900">$5,000.00</p>
                                <p class="text-xs text-slate-500">Completed</p>
                            </div>
                        </div>

                    </div>
                    <button class="w-full mt-6 py-2 px-4 border border-slate-200 rounded-lg text-sm text-slate-600 hover:bg-slate-50 transition-colors">
                        View All History
                    </button>
                </div>

            </div>
        </div>
    </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script>
// Toggle Sidebar for Mobile
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const isClosed = sidebar.classList.contains('-translate-x-full');
    
    if (isClosed) {
        sidebar.classList.remove('-translate-x-full');
        overlay.classList.remove('hidden');
    } else {
        sidebar.classList.add('-translate-x-full');
        overlay.classList.add('hidden');
    }
}

// --- Charts Configuration ---

// 1. Area Chart (Portfolio Growth)
const growthOptions = {
    series: [{
        name: 'Portfolio Value',
        data: [124000, 128500, 126000, 132000, 138000, 135000, 142000, 149000, 146500, 155000, 162000, <?php echo e(Auth::user()->balance); ?>]
    }],
    chart: {
        type: 'area',
        height: 300,
        background: 'transparent',
        toolbar: { show: false },
        fontFamily: 'inherit'
    },
    colors: ['#10b981'], // Green-500
    fill: {
        type: 'gradient',
        gradient: {
            shadeIntensity: 1,
            opacityFrom: 0.4,
            opacityTo: 0.05,
            stops: [0, 90, 100]
        }
    },
    dataLabels: { enabled: false },
    stroke: {
        curve: 'smooth',
        width: 2
    },
    xaxis: {
        categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        axisBorder: { show: false },
        axisTicks: { show: false },
        labels: {
            style: { colors: '#94a3b8' } // Slate-400
        }
    },
    yaxis: {
        labels: {
            style: { colors: '#94a3b8' },
            formatter: (value) => { return "$" + (value / 1000).toFixed(0) + "k" }
        }
    },
    grid: {
        borderColor: '#e2e8f0', // Slate-200
        strokeDashArray: 4,
        yaxis: { lines: { show: true } },
        xaxis: { lines: { show: false } }
    },
    tooltip: {
        theme: 'light',
        y: { formatter: function (val) { return "$" + val.toLocaleString() } }
    }
};

const growthChart = new ApexCharts(document.querySelector("#growthChart"), growthOptions);
growthChart.render();

// 2. Donut Chart (Allocation)
const allocationOptions = {
    series: [45, 20, 15, 10, 10],
    labels: ['Technology', 'Real Estate', 'Crypto', 'Bonds', 'Cash'],
    chart: {
        type: 'donut',
        height: 220,
        background: 'transparent'
    },
    colors: ['#10b981', '#8b5cf6', '#f59e0b', '#3b82f6', '#94a3b8'],
    plotOptions: {
        pie: {
            donut: {
                size: '75%',
                labels: { show: false }
            }
        }
    },
    dataLabels: { enabled: false },
    legend: { show: false }, // Using custom HTML legend
    stroke: { show: false },
    tooltip: {
        theme: 'light',
        y: { formatter: function (val) { return val + "%" } }
    }
};

const allocationChart = new ApexCharts(document.querySelector("#allocationChart"), allocationOptions);
allocationChart.render();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\algotrade_withdemo\resources\views/user/dashboard.blade.php ENDPATH**/ ?>