@extends('layouts.base')

@section('title', 'Home')

@inject('content', 'App\Http\Controllers\FrontController')
@section('content')

<!-- Hero Section -->
<section class="relative pt-32 pb-20 lg:pt-40 lg:pb-28 overflow-hidden bg-slate-50">
    <!-- Background Decor -->
    <div class="absolute top-0 right-0 -mr-20 -mt-20 w-96 h-96 rounded-full bg-primary-100 blur-3xl opacity-50"></div>
    <div class="absolute bottom-0 left-0 -ml-20 -mb-20 w-80 h-80 rounded-full bg-blue-100 blur-3xl opacity-50"></div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="grid lg:grid-cols-2 gap-12 lg:gap-8 items-center">
            <!-- Content -->
            <div class="text-center lg:text-left">
                <div class="inline-flex items-center px-3 py-1 rounded-full bg-primary-50 text-primary-700 text-sm font-medium mb-6 border border-primary-100">
                    <span class="w-2 h-2 rounded-full bg-primary-500 mr-2 animate-pulse"></span>
                    New: AI-Powered Portfolio Balancing
                </div>
                <h1 class="text-4xl lg:text-6xl font-bold text-slate-900 tracking-tight mb-6 leading-tight">
                    Invest in your future with <span class="text-primary-600">confidence.</span>
                </h1>
                <p class="text-lg text-slate-600 mb-8 leading-relaxed max-w-2xl mx-auto lg:mx-0">
                    {{$settings->site_name}} makes it easy to build wealth. Access stocks, ETFs, and crypto in one secure platform with low fees and expert guidance.
                </p>
                <div class="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-4">
                    <a href="register" class="w-full sm:w-auto px-8 py-4 bg-primary-600 hover:bg-primary-700 text-white rounded-xl font-semibold shadow-xl shadow-primary-600/20 transition-all transform hover:-translate-y-1">
                        Open Free Account
                    </a>
                    <a href="login" class="w-full sm:w-auto px-8 py-4 bg-white hover:bg-slate-50 text-slate-700 border border-slate-200 rounded-xl font-semibold transition-all flex items-center justify-center gap-2 group">
                        <i class="fas fa-sign-in-alt text-primary-600 group-hover:scale-110 transition-transform"></i>
                        Sign In
                    </a>
                </div>
                <div class="mt-8 flex items-center justify-center lg:justify-start gap-6 text-slate-500 text-sm">
                    <div class="flex items-center gap-2">
                        <i class="fas fa-check-circle text-primary-600"></i> No hidden fees
                    </div>
                    <div class="flex items-center gap-2">
                        <i class="fas fa-check-circle text-primary-600"></i> SEC Regulated
                    </div>
                    <div class="flex items-center gap-2">
                        <i class="fas fa-check-circle text-primary-600"></i> Bank-level security
                    </div>
                </div>
            </div>

            <!-- Hero Image/Graphic -->
            <div class="relative lg:h-[600px] flex items-center justify-center">
                <div class="relative w-full max-w-md lg:max-w-full aspect-square lg:aspect-auto">
                     <!-- Decorative elements -->
                     <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[120%] h-[120%] bg-gradient-to-tr from-primary-100 to-blue-50 rounded-full blur-2xl opacity-60"></div>
                     
                     <!-- Mockup Card -->
                     <div class="absolute top-10 right-0 lg:right-10 bg-white p-4 rounded-2xl shadow-2xl z-20 animate-[bounce_3s_infinite]">
                         <div class="flex items-center gap-3">
                             <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center text-green-600">
                                 <i class="fas fa-arrow-up text-xl"></i>
                             </div>
                             <div>
                                 <p class="text-xs text-slate-500">Total Yield</p>
                                 <p class="font-bold text-slate-900">+24.5%</p>
                             </div>
                         </div>
                     </div>

                     <!-- Main Image -->
                     <img src="https://images.unsplash.com/photo-1611974765270-ca12586343bb?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80" alt="Investment Dashboard" class="relative z-10 rounded-2xl shadow-2xl border-4 border-white object-cover h-full w-full">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Live Ticker Section -->
<div class="bg-slate-900 py-4 overflow-hidden border-y border-slate-800">
    <div class="tradingview-widget-container">
        <div class="tradingview-widget-container__widget"></div>
        <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
        {
        "symbols": [
            {"proName": "FOREXCOM:SPXUSD", "title": "S&P 500"},
            {"proName": "FOREXCOM:NSXUSD", "title": "Nasdaq 100"},
            {"proName": "FX_IDC:EURUSD", "title": "EUR/USD"},
            {"proName": "BITSTAMP:BTCUSD", "title": "BTC/USD"},
            {"proName": "BITSTAMP:ETHUSD", "title": "ETH/USD"}
        ],
        "showSymbolLogo": true,
        "colorTheme": "dark",
        "isTransparent": false,
        "displayMode": "adaptive",
        "locale": "en"
        }
        </script>
    </div>
</div>

<!-- Stats Section -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 text-center divide-x divide-slate-100">
            <div class="p-4">
                <p class="text-4xl font-bold text-slate-900 mb-2">$2B+</p>
                <p class="text-slate-500">Assets Managed</p>
            </div>
            <div class="p-4">
                <p class="text-4xl font-bold text-slate-900 mb-2">4.5M</p>
                <p class="text-slate-500">Verified Users</p>
            </div>
            <div class="p-4">
                <p class="text-4xl font-bold text-slate-900 mb-2">0.0%</p>
                <p class="text-slate-500">Commission Fees</p>
            </div>
            <div class="p-4">
                <p class="text-4xl font-bold text-slate-900 mb-2">24/7</p>
                <p class="text-slate-500">Support Access</p>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-20 bg-slate-50" id="features">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <h2 class="text-base text-primary-600 font-semibold tracking-wide uppercase mb-2">Why {{$settings->site_name}}</h2>
            <p class="text-3xl font-bold text-slate-900 sm:text-4xl mb-4">Smart tools for smarter investors</p>
            <p class="text-lg text-slate-600">We provide the professional-grade tools you need to analyze, track, and grow your portfolio, simplified for everyone.</p>
        </div>

        <div class="grid md:grid-cols-3 gap-8">
            <!-- Feature 1 -->
            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-xl transition-shadow border border-slate-100">
                <div class="w-14 h-14 bg-blue-50 rounded-xl flex items-center justify-center text-blue-600 mb-6">
                    <i class="fas fa-chart-pie text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-900 mb-3">Automated Rebalancing</h3>
                <p class="text-slate-600 leading-relaxed">Our algorithms automatically adjust your portfolio to maintain your desired risk level and asset allocation.</p>
            </div>

            <!-- Feature 2 -->
            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-xl transition-shadow border border-slate-100">
                <div class="w-14 h-14 bg-green-50 rounded-xl flex items-center justify-center text-green-600 mb-6">
                    <i class="fas fa-shield-alt text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-900 mb-3">Bank-Grade Security</h3>
                <p class="text-slate-600 leading-relaxed">Your data is encrypted with 256-bit AES technology, and your funds are insured up to $500,000.</p>
            </div>

            <!-- Feature 3 -->
            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-xl transition-shadow border border-slate-100">
                <div class="w-14 h-14 bg-purple-50 rounded-xl flex items-center justify-center text-purple-600 mb-6">
                    <i class="fas fa-users text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-slate-900 mb-3">Expert Community</h3>
                <p class="text-slate-600 leading-relaxed">Follow top-performing investors, copy their trades, and learn from a community of millions.</p>
            </div>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="py-20 bg-white border-y border-slate-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <h2 class="text-3xl font-bold text-slate-900 sm:text-4xl mb-4">From zero to investor in minutes</h2>
            <p class="text-lg text-slate-600">We've stripped away the complexity so you can focus on the returns.</p>
        </div>
        
        <div class="relative">
            <!-- Connector Line (Desktop) -->
            <div class="hidden md:block absolute top-12 left-0 w-full h-0.5 bg-slate-100 -z-10"></div>
            
            <div class="grid md:grid-cols-3 gap-12">
                <!-- Step 1 -->
                <div class="relative bg-white pt-4 md:pt-0">
                    <div class="w-24 h-24 mx-auto bg-white rounded-full border-8 border-slate-50 flex items-center justify-center mb-6 relative z-10">
                        <div class="w-12 h-12 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center text-xl font-bold">1</div>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 text-center mb-3">Create an Account</h3>
                    <p class="text-slate-600 text-center leading-relaxed">Verify your identity in minutes with our secure, automated onboarding process.</p>
                </div>

                <!-- Step 2 -->
                <div class="relative bg-white pt-4 md:pt-0">
                    <div class="w-24 h-24 mx-auto bg-white rounded-full border-8 border-slate-50 flex items-center justify-center mb-6 relative z-10">
                        <div class="w-12 h-12 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center text-xl font-bold">2</div>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 text-center mb-3">Link Your Bank</h3>
                    <p class="text-slate-600 text-center leading-relaxed">Securely connect your funding source. We support over 3,000 global financial institutions.</p>
                </div>

                <!-- Step 3 -->
                <div class="relative bg-white pt-4 md:pt-0">
                    <div class="w-24 h-24 mx-auto bg-white rounded-full border-8 border-slate-50 flex items-center justify-center mb-6 relative z-10">
                        <div class="w-12 h-12 bg-primary-100 text-primary-600 rounded-full flex items-center justify-center text-xl font-bold">3</div>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 text-center mb-3">Start Growing</h3>
                    <p class="text-slate-600 text-center leading-relaxed">Choose a portfolio strategy or pick your own stocks. Monitor your growth in real-time.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Investment Plans -->
<section class="py-20 bg-white" id="plans">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center max-w-3xl mx-auto mb-16">
            <h2 class="text-3xl font-bold text-slate-900 sm:text-4xl mb-4">Choose your investing style</h2>
            <p class="text-lg text-slate-600">Whether you're hands-on or hands-off, we have a plan for you.</p>
        </div>

        <div class="grid lg:grid-cols-3 gap-8 items-start">
            @foreach($plans->take(3) as $index => $plan)
            <!-- Plan Card -->
            <div class="bg-white border border-slate-200 rounded-2xl p-8 relative hover:border-primary-200 transition-colors {{ $index === 1 ? 'bg-slate-900 transform scale-105 z-10 shadow-2xl' : '' }}">
                @if($index === 1)
                <div class="absolute top-0 right-0 bg-primary-500 text-white text-xs font-bold px-3 py-1 rounded-bl-lg rounded-tr-lg">POPULAR</div>
                @endif
                <h3 class="text-xl font-bold {{ $index === 1 ? 'text-white' : 'text-slate-900' }} mb-2">{{$plan->name}}</h3>
                <p class="{{ $index === 1 ? 'text-slate-400' : 'text-slate-500' }} text-sm mb-6">Professional trading</p>
                <div class="flex items-baseline mb-6">
                    <span class="text-4xl font-bold {{ $index === 1 ? 'text-white' : 'text-slate-900' }}">{{$plan->increment_amount}}%</span>
                    <span class="{{ $index === 1 ? 'text-slate-400' : 'text-slate-500' }} ml-2">ROI</span>
                </div>
                <ul class="space-y-4 mb-8">
                    <li class="flex items-center {{ $index === 1 ? 'text-slate-300' : 'text-slate-600' }}">
                        <i class="fas fa-check {{ $index === 1 ? 'text-primary-400' : 'text-green-500' }} mr-3"></i> 
                        Min: ${{number_format($plan->min_price)}}
                    </li>
                    <li class="flex items-center {{ $index === 1 ? 'text-slate-300' : 'text-slate-600' }}">
                        <i class="fas fa-check {{ $index === 1 ? 'text-primary-400' : 'text-green-500' }} mr-3"></i> 
                        Max: ${{number_format($plan->max_price)}}
                    </li>
                    <li class="flex items-center {{ $index === 1 ? 'text-slate-300' : 'text-slate-600' }}">
                        <i class="fas fa-check {{ $index === 1 ? 'text-primary-400' : 'text-green-500' }} mr-3"></i> 
                        24/7 Support
                    </li>
                    <li class="flex items-center {{ $index === 1 ? 'text-slate-300' : 'text-slate-600' }}">
                        <i class="fas fa-check {{ $index === 1 ? 'text-primary-400' : 'text-green-500' }} mr-3"></i> 
                        Instant Withdrawal
                    </li>
                </ul>
                <a href="login" class="w-full py-3 {{ $index === 1 ? 'bg-primary-600 text-white hover:bg-primary-700 shadow-lg shadow-primary-600/30' : 'bg-slate-50 text-slate-900 border border-slate-200 hover:bg-slate-100' }} font-semibold rounded-xl transition-colors block text-center">
                    {{ $index === 1 ? 'Start Investing' : 'Select Plan' }}
                </a>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Testimonial Section -->
<section class="py-20 bg-slate-50" id="testimonials">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-slate-900 text-center mb-12">Trusted by investors like you</h2>
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Review 1 -->
            <div class="bg-white p-8 rounded-2xl shadow-sm">
                <div class="flex text-yellow-400 mb-4">
                    <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                </div>
                <p class="text-slate-600 mb-6">"{{$settings->site_name}} simplified my entire financial life. I used to worry about balancing my portfolio, now it's all automated. The returns have been steady and reliable."</p>
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full bg-slate-200 mr-3 overflow-hidden">
                         <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80" alt="User" class="w-full h-full object-cover">
                    </div>
                    <div>
                        <p class="font-bold text-slate-900 text-sm">Marcus Thompson</p>
                        <p class="text-slate-500 text-xs">Software Engineer</p>
                    </div>
                </div>
            </div>

            <!-- Review 2 -->
            <div class="bg-white p-8 rounded-2xl shadow-sm">
                <div class="flex text-yellow-400 mb-4">
                    <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                </div>
                <p class="text-slate-600 mb-6">"The educational resources are top-notch. I started as a complete beginner, and now I feel confident making my own trades. Highly recommended platform."</p>
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full bg-slate-200 mr-3 overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80" alt="User" class="w-full h-full object-cover">
                    </div>
                    <div>
                        <p class="font-bold text-slate-900 text-sm">Sarah Chen</p>
                        <p class="text-slate-500 text-xs">Marketing Director</p>
                    </div>
                </div>
            </div>

            <!-- Review 3 -->
            <div class="bg-white p-8 rounded-2xl shadow-sm hidden lg:block">
                <div class="flex text-yellow-400 mb-4">
                    <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i>
                </div>
                <p class="text-slate-600 mb-6">"Low fees and great execution speed. The mobile app is incredibly intuitive compared to other brokers I've used in the past."</p>
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full bg-slate-200 mr-3 overflow-hidden">
                         <img src="https://images.unsplash.com/photo-1500648767791-00dcc994a43e?ixlib=rb-4.0.3&auto=format&fit=crop&w=100&q=80" alt="User" class="w-full h-full object-cover">
                    </div>
                    <div>
                        <p class="font-bold text-slate-900 text-sm">David Miller</p>
                        <p class="text-slate-500 text-xs">Entrepreneur</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-20 bg-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-slate-900 text-center mb-12">Frequently Asked Questions</h2>
        
        <div class="space-y-4">
            <!-- FAQ Item 1 -->
            <details class="group bg-slate-50 rounded-2xl p-6 [&_summary::-webkit-details-marker]:hidden">
                <summary class="flex cursor-pointer items-center justify-between gap-1.5 text-slate-900 font-bold">
                    <span class="text-lg">Is my money safe with {{$settings->site_name}}?</span>
                    <span class="shrink-0 rounded-full bg-white p-1.5 text-slate-900 sm:p-3 shadow-sm group-open:-rotate-180 transition-transform duration-300">
                        <i class="fas fa-chevron-down"></i>
                    </span>
                </summary>
                <p class="mt-4 leading-relaxed text-slate-600">
                    Absolutely. We use bank-grade encryption to protect your personal data. Additionally, securities in your account are protected up to $500,000 by SIPC.
                </p>
            </details>

            <!-- FAQ Item 2 -->
            <details class="group bg-slate-50 rounded-2xl p-6 [&_summary::-webkit-details-marker]:hidden">
                <summary class="flex cursor-pointer items-center justify-between gap-1.5 text-slate-900 font-bold">
                    <span class="text-lg">Can I withdraw my money at any time?</span>
                    <span class="shrink-0 rounded-full bg-white p-1.5 text-slate-900 sm:p-3 shadow-sm group-open:-rotate-180 transition-transform duration-300">
                        <i class="fas fa-chevron-down"></i>
                    </span>
                </summary>
                <p class="mt-4 leading-relaxed text-slate-600">
                    Yes, you have full liquidity. You can sell your assets and withdraw cash to your linked bank account at any time. Standard settlement times (usually 2 days) apply.
                </p>
            </details>

            <!-- FAQ Item 3 -->
            <details class="group bg-slate-50 rounded-2xl p-6 [&_summary::-webkit-details-marker]:hidden">
                <summary class="flex cursor-pointer items-center justify-between gap-1.5 text-slate-900 font-bold">
                    <span class="text-lg">How does the automated investing work?</span>
                    <span class="shrink-0 rounded-full bg-white p-1.5 text-slate-900 sm:p-3 shadow-sm group-open:-rotate-180 transition-transform duration-300">
                        <i class="fas fa-chevron-down"></i>
                    </span>
                </summary>
                <p class="mt-4 leading-relaxed text-slate-600">
                    Our system analyzes your financial goals and risk tolerance to build a diversified portfolio. It then automatically rebalances your investments as the market moves to keep you on track.
                </p>
            </details>

            <!-- FAQ Item 4 -->
            <details class="group bg-slate-50 rounded-2xl p-6 [&_summary::-webkit-details-marker]:hidden">
                <summary class="flex cursor-pointer items-center justify-between gap-1.5 text-slate-900 font-bold">
                    <span class="text-lg">Are there any hidden fees?</span>
                    <span class="shrink-0 rounded-full bg-white p-1.5 text-slate-900 sm:p-3 shadow-sm group-open:-rotate-180 transition-transform duration-300">
                        <i class="fas fa-chevron-down"></i>
                    </span>
                </summary>
                <p class="mt-4 leading-relaxed text-slate-600">
                    Never. We believe in transparency. Our fee structure is simple and clear. No transfer fees, no inactivity fees, no hidden charges.
                </p>
            </details>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-20">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-primary-600 rounded-3xl p-10 md:p-16 text-center text-white relative overflow-hidden shadow-2xl">
            <!-- Decor -->
            <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-10 rounded-full -mr-16 -mt-16 blur-2xl"></div>
            <div class="absolute bottom-0 left-0 w-48 h-48 bg-black opacity-10 rounded-full -ml-10 -mb-10 blur-xl"></div>
            
            <h2 class="text-3xl md:text-5xl font-bold mb-6 relative z-10">Start growing your wealth today.</h2>
            <p class="text-primary-100 text-lg mb-8 max-w-2xl mx-auto relative z-10">Join over 4 million investors who trust {{$settings->site_name}}. Setup takes less than 5 minutes.</p>
            
            <div class="flex flex-col sm:flex-row justify-center gap-4 relative z-10">
                <a href="register" class="px-8 py-4 bg-white text-primary-700 font-bold rounded-xl shadow-lg hover:bg-slate-50 transition-colors">Create Account</a>
                <a href="login" class="px-8 py-4 bg-primary-700 text-white font-bold rounded-xl border border-primary-500 hover:bg-primary-800 transition-colors">Sign In</a>
            </div>
            <p class="mt-6 text-sm text-primary-200">Capital at risk. Past performance is not an indication of future results.</p>
        </div>
    </div>
</section>

@endsection
