@props(['label', 'value', 'icon', 'primary' => false])

<div class="{{ $primary ? 'bg-[#34495e] text-white' : 'bg-white' }} p-6 shadow-sm">
    <div class="flex items-center justify-between mb-2">
        <span class="text-sm font-medium {{ $primary ? 'text-white' : 'text-gray-600' }}">{{ $label }}</span>
        <i data-lucide="{{ $icon }}" class="w-5 h-5 {{ $primary ? 'text-white' : 'text-[#f39c12]' }}"></i>
    </div>
    <div class="text-3xl font-bold {{ $primary ? 'text-white' : 'text-gray-900' }}">{{ $value }}</div>
</div>
