-- Populate instruments table with sample data
INSERT INTO `instruments` (`symbol`, `name`, `type`, `price`, `percent_change_24h`, `change`, `volume`, `market_cap`, `logo`, `created_at`, `updated_at`) VALUES
('BTC', 'Bitcoin', 'crypto', 45000.00, 2.5, 1125.00, 28000000000, 850000000000, 'https://assets.coingecko.com/coins/images/1/small/bitcoin.png', NOW(), NOW()),
('ETH', 'Ethereum', 'crypto', 2800.00, 3.2, 89.60, 15000000000, 340000000000, 'https://assets.coingecko.com/coins/images/279/small/ethereum.png', NOW(), NOW()),
('BNB', 'Binance Coin', 'crypto', 320.00, 1.8, 5.76, 1200000000, 50000000000, 'https://assets.coingecko.com/coins/images/825/small/bnb-icon2_2x.png', NOW(), NOW()),
('SOL', 'Solana', 'crypto', 95.00, 5.5, 5.23, 800000000, 40000000000, 'https://assets.coingecko.com/coins/images/4128/small/solana.png', NOW(), NOW()),
('XRP', 'Ripple', 'crypto', 0.52, -1.2, -0.006, 1500000000, 28000000000, 'https://assets.coingecko.com/coins/images/44/small/xrp-symbol-white-128.png', NOW(), NOW()),
('ADA', 'Cardano', 'crypto', 0.45, 2.1, 0.009, 600000000, 16000000000, 'https://assets.coingecko.com/coins/images/975/small/cardano.png', NOW(), NOW()),
('DOGE', 'Dogecoin', 'crypto', 0.08, 4.5, 0.0036, 500000000, 11000000000, 'https://assets.coingecko.com/coins/images/5/small/dogecoin.png', NOW(), NOW()),
('DOT', 'Polkadot', 'crypto', 6.50, 1.5, 0.098, 300000000, 8500000000, 'https://assets.coingecko.com/coins/images/12171/small/polkadot.png', NOW(), NOW()),
('MATIC', 'Polygon', 'crypto', 0.85, 3.8, 0.032, 400000000, 7800000000, 'https://assets.coingecko.com/coins/images/4713/small/matic-token-icon.png', NOW(), NOW()),
('LTC', 'Litecoin', 'crypto', 72.00, 0.8, 0.58, 450000000, 5300000000, 'https://assets.coingecko.com/coins/images/2/small/litecoin.png', NOW(), NOW()),
('AVAX', 'Avalanche', 'crypto', 28.00, 2.9, 0.81, 350000000, 10000000000, 'https://assets.coingecko.com/coins/images/12559/small/coin-round-red.png', NOW(), NOW()),
('LINK', 'Chainlink', 'crypto', 14.50, 1.2, 0.17, 280000000, 8200000000, 'https://assets.coingecko.com/coins/images/877/small/chainlink-new-logo.png', NOW(), NOW()),
('UNI', 'Uniswap', 'crypto', 6.80, -0.5, -0.034, 180000000, 5100000000, 'https://assets.coingecko.com/coins/images/12504/small/uniswap-uni.png', NOW(), NOW()),
('EURUSD', 'Euro/US Dollar', 'forex', 1.0850, 0.15, 0.0016, 5000000000, NULL, NULL, NOW(), NOW()),
('GBPUSD', 'British Pound/US Dollar', 'forex', 1.2650, -0.08, -0.001, 4500000000, NULL, NULL, NOW(), NOW()),
('USDJPY', 'US Dollar/Japanese Yen', 'forex', 148.50, 0.25, 0.37, 4200000000, NULL, NULL, NOW(), NOW()),
('AAPL', 'Apple Inc.', 'stock', 178.50, 1.2, 2.12, 85000000000, 2800000000000, NULL, NOW(), NOW()),
('MSFT', 'Microsoft Corporation', 'stock', 385.00, 0.8, 3.08, 45000000000, 2900000000000, NULL, NOW(), NOW()),
('GOOGL', 'Alphabet Inc.', 'stock', 142.00, 1.5, 2.10, 38000000000, 1800000000000, NULL, NOW(), NOW()),
('TSLA', 'Tesla Inc.', 'stock', 245.00, 3.2, 7.60, 95000000000, 780000000000, NULL, NOW(), NOW()),
('GOLD', 'Gold', 'commodity', 2050.00, 0.5, 10.25, 180000000000, NULL, NULL, NOW(), NOW()),
('SILVER', 'Silver', 'commodity', 24.50, 1.2, 0.29, 25000000000, NULL, NULL, NOW(), NOW()),
('USOIL', 'Crude Oil', 'commodity', 78.50, -0.8, -0.63, 120000000000, NULL, NULL, NOW(), NOW())
ON DUPLICATE KEY UPDATE 
    `price` = VALUES(`price`),
    `percent_change_24h` = VALUES(`percent_change_24h`),
    `change` = VALUES(`change`),
    `volume` = VALUES(`volume`),
    `updated_at` = NOW();
