<?php

use Illuminate\Support\Facades\DB;
use App\Models\Investment;
use App\Models\Plans;
use Carbon\Carbon;

// Check for due investments
echo "=== ROI Processing Debug Check ===\n\n";

// Get all active investments
$activeInvestments = Investment::where('active', 'yes')->with(['uplan', 'puser'])->get();
echo "Total active investments: " . $activeInvestments->count() . "\n\n";

if ($activeInvestments->count() > 0) {
    echo "Active investments details:\n";
    $dueCount = 0;

    foreach ($activeInvestments as $investment) {
        $plan = $investment->uplan;
        $user = $investment->puser;

        if (!$plan || !$user) {
            continue;
        }

        $now = Carbon::now();
        $lastGrowth = $investment->last_growth;

        if (!$lastGrowth) {
            $lastGrowth = $investment->activated_at ?: $investment->created_at;
        }

        // Calculate next drop time based on plan interval
        $nextDrop = match($plan->increment_interval) {
            'Monthly' => $lastGrowth->copy()->addDays(30),
            'Weekly' => $lastGrowth->copy()->addWeek(),
            'Daily' => $lastGrowth->copy()->addDay(),
            'Hourly' => $lastGrowth->copy()->addHour(),
            'Every 30 Minutes' => $lastGrowth->copy()->addMinutes(30),
            'Every 10 Minutes' => $lastGrowth->copy()->addMinutes(10),
            default => $lastGrowth->copy()->addDay(),
        };

        $isDue = $now->greaterThanOrEqualTo($nextDrop);

        echo "ID: {$investment->id}\n";
        echo "User: {$user->name}\n";
        echo "Plan: {$plan->name} ({$plan->increment_interval})\n";
        echo "Amount: \${$investment->amount}\n";
        echo "Last Growth: " . $lastGrowth->format('Y-m-d H:i:s') . "\n";
        echo "Next Drop: " . $nextDrop->format('Y-m-d H:i:s') . "\n";
        echo "Current Time: " . $now->format('Y-m-d H:i:s') . "\n";
        echo "Due for ROI: " . ($isDue ? 'YES' : 'NO') . "\n";
        echo "---\n";

        if ($isDue) {
            $dueCount++;
        }
    }

    echo "\nInvestments due for ROI: {$dueCount}\n";

} else {
    echo "No active investments found.\n";
}

echo "\n=== End Debug Check ===\n";
