<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\AutoTaskController;

class RunAutoTasks extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'auto:run-tasks';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run automatic tasks for ROI, trading profits, copy trading, bot trading, and demo trading';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Starting automatic tasks...');

        try {
            $autoTaskController = new AutoTaskController();

            // Run all automatic tasks
            $this->info('Running automatic ROI calculations...');
            $autoTaskController->automaticRoi();

            $this->info('Running plan investment returns job...');
            \App\Jobs\ProcessPlanInvestmentReturns::dispatchSync();

            $this->info('Running automatic trading profit calculations...');
            $autoTaskController->automaticTradingProfit();

            $this->info('Running automatic copy trading profits...');
            $autoTaskController->automaticCopyTradingProfits();

            $this->info('Running automatic bot trading profits...');
            $autoTaskController->automaticBotTradingProfits();

            $this->info('Running automatic demo trading updates...');
            $autoTaskController->automaticDemoTradingUpdates();

            $this->info('All automatic tasks completed successfully!');

            return Command::SUCCESS;

        } catch (\Exception $e) {
            $this->error('Error running automatic tasks: ' . $e->getMessage());
            \Log::error('AutoTask Command Error: ' . $e->getMessage());

            return Command::FAILURE;
        }
    }
}
