<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h1 class="title1">Investment ROI Management</h1>
                            <p class="text-muted">Monitor and manage ROI calculations for all investment plans</p>
                        </div>
                        <div>
                            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#processROIModal">
                                <i class="fa fa-cogs"></i> Process ROI Now
                            </button>
                            <a href="<?php echo e(route('plans')); ?>" class="btn btn-sm btn-primary">
                                <i class="fa fa-arrow-left"></i> Back to Plans
                            </a>
                        </div>
                    </div>
                </div>

                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <!-- ROI Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card card-stats card-primary">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-chart-line"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Active Investments</p>
                                            <h4 class="card-title"><?php echo e($stats['active_investments']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card card-stats card-success">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-dollar-sign"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total ROI Paid</p>
                                            <h4 class="card-title"><?php echo e($settings->currency); ?><?php echo e(number_format($stats['total_roi_paid'], 2)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card card-stats card-info">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-coins"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Total Invested</p>
                                            <h4 class="card-title"><?php echo e($settings->currency); ?><?php echo e(number_format($stats['total_invested'], 2)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card card-stats card-warning">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-5">
                                        <div class="icon-big text-center">
                                            <i class="fas fa-clock"></i>
                                        </div>
                                    </div>
                                    <div class="col-7 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">Expiring Soon</p>
                                            <h4 class="card-title"><?php echo e($stats['expiring_soon']); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Investment Plans Performance -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Investment Plans Performance</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Plan Name</th>
                                                <th>Active Investments</th>
                                                <th>Total Invested</th>
                                                <th>Total ROI Paid</th>
                                                <th>ROI Rate</th>
                                                <th>Performance</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $planStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planStat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <strong><?php echo e($planStat->name); ?></strong>
                                                        <?php if($planStat->tag): ?>
                                                            <span class="badge badge-info ml-2"><?php echo e($planStat->tag); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($planStat->active_investments); ?></td>
                                                    <td><?php echo e($settings->currency); ?><?php echo e(number_format($planStat->total_invested, 2)); ?></td>
                                                    <td><?php echo e($settings->currency); ?><?php echo e(number_format($planStat->total_roi_paid, 2)); ?></td>
                                                    <td><?php echo e($planStat->increment_amount); ?>% <?php echo e($planStat->increment_interval); ?></td>
                                                    <td>
                                                        <?php
                                                            $performance = $planStat->total_invested > 0 ? ($planStat->total_roi_paid / $planStat->total_invested) * 100 : 0;
                                                        ?>
                                                        <div class="progress">
                                                            <div class="progress-bar" style="width: <?php echo e(min($performance, 100)); ?>%">
                                                                <?php echo e(number_format($performance, 1)); ?>%
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Active Investments List -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h4 class="card-title">Active Investments</h4>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-sm btn-outline-secondary dropdown-toggle" data-toggle="dropdown">
                                            Filter <span class="caret"></span>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?filter=all">All Investments</a>
                                            <a class="dropdown-item" href="?filter=due_roi">Due for ROI</a>
                                            <a class="dropdown-item" href="?filter=expiring">Expiring Soon</a>
                                            <a class="dropdown-item" href="?filter=high_profit">High Profit</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="investmentTable" class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Investor</th>
                                                <th>Plan</th>
                                                <th>Amount</th>
                                                <th>Profit Earned</th>
                                                <th>Last ROI</th>
                                                <th>Next ROI</th>
                                                <th>Expires</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>#<?php echo e($investment->id); ?></td>
                                                    <td>
                                                        <?php if($investment->puser): ?>
                                                            <div class="d-flex align-items-center">
                                                                <div class="avatar avatar-sm mr-2">
                                                                    <span class="avatar-title bg-primary rounded-circle">
                                                                        <?php echo e(substr($investment->puser->name, 0, 1)); ?>

                                                                    </span>
                                                                </div>
                                                                <div>
                                                                    <strong><?php echo e($investment->puser->name); ?></strong><br>
                                                                    <small class="text-muted"><?php echo e($investment->puser->email); ?></small>
                                                                </div>
                                                            </div>
                                                        <?php else: ?>
                                                            <span class="text-muted">User Deleted</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($investment->uplan): ?>
                                                            <strong><?php echo e($investment->uplan->name); ?></strong><br>
                                                            <small class="text-muted"><?php echo e($investment->uplan->increment_amount); ?>% <?php echo e($investment->uplan->increment_interval); ?></small>
                                                        <?php else: ?>
                                                            <span class="text-muted">Plan Deleted</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($settings->currency); ?><?php echo e(number_format($investment->amount, 2)); ?></td>
                                                    <td>
                                                        <span class="text-success">
                                                            <?php echo e($settings->currency); ?><?php echo e(number_format($investment->profit_earned ?? 0, 2)); ?>

                                                        </span>
                                                    </td>
                                                    <td>
                                                        <?php if($investment->last_growth): ?>
                                                            <?php echo e($investment->last_growth->format('M j, Y H:i')); ?>

                                                        <?php else: ?>
                                                            <span class="text-muted">Never</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($investment->uplan && $investment->last_growth): ?>
                                                            <?php
                                                                $nextROI = match($investment->uplan->increment_interval) {
                                                                    'Monthly' => $investment->last_growth->addDays(30),
                                                                    'Weekly' => $investment->last_growth->addWeek(),
                                                                    'Daily' => $investment->last_growth->addDay(),
                                                                    'Hourly' => $investment->last_growth->addHour(),
                                                                    'Every 30 Minutes' => $investment->last_growth->addMinutes(30),
                                                                    'Every 10 Minutes' => $investment->last_growth->addMinutes(10),
                                                                    default => $investment->last_growth->addDay(),
                                                                };
                                                            ?>
                                                            <span class="<?php echo e($nextROI->isPast() ? 'text-warning' : 'text-info'); ?>">
                                                                <?php echo e($nextROI->format('M j, Y H:i')); ?>

                                                            </span>
                                                            <?php if($nextROI->isPast()): ?>
                                                                <br><small class="text-warning">Due Now!</small>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <span class="text-muted">N/A</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <span class="<?php echo e($investment->expire_date->isPast() ? 'text-danger' : 'text-info'); ?>">
                                                            <?php echo e($investment->expire_date->format('M j, Y H:i')); ?>

                                                        </span>
                                                        <?php if($investment->expire_date->diffInDays() <= 3 && !$investment->expire_date->isPast()): ?>
                                                            <br><small class="text-warning">Expiring Soon</small>
                                                        <?php elseif($investment->expire_date->isPast()): ?>
                                                            <br><small class="text-danger">Expired</small>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($investment->active == 'yes'): ?>
                                                            <span class="badge badge-success">Active</span>
                                                        <?php elseif($investment->active == 'expired'): ?>
                                                            <span class="badge badge-danger">Expired</span>
                                                        <?php else: ?>
                                                            <span class="badge badge-secondary"><?php echo e(ucfirst($investment->active)); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <button type="button" class="btn btn-sm btn-outline-primary dropdown-toggle" data-toggle="dropdown">
                                                                Actions
                                                            </button>
                                                            <div class="dropdown-menu">
                                                                <?php if($investment->active == 'yes'): ?>
                                                                    <a class="dropdown-item" href="#" onclick="processROI(<?php echo e($investment->id); ?>)">
                                                                        <i class="fas fa-play"></i> Process ROI Now
                                                                    </a>
                                                                    <a class="dropdown-item" href="<?php echo e(route('markas', ['id' => $investment->id, 'status' => 'expired'])); ?>">
                                                                        <i class="fas fa-stop"></i> Mark as Expired
                                                                    </a>
                                                                <?php endif; ?>
                                                                <?php if($investment->puser): ?>
                                                                    <a class="dropdown-item text-info" href="<?php echo e(route('user.plans', $investment->puser->id)); ?>">
                                                                        <i class="fas fa-eye"></i> View User Plans
                                                                    </a>
                                                                <?php endif; ?>
                                                                <div class="dropdown-divider"></div>
                                                                <a class="dropdown-item text-danger" href="<?php echo e(route('deleteinvestment', $investment->id)); ?>" onclick="return confirm('Are you sure you want to delete this investment? The capital will be refunded to the user.')">
                                                                    <i class="fas fa-trash"></i> Delete Investment
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Pagination -->
                                <div class="d-flex justify-content-center">
                                    <?php echo e($investments->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Process ROI Modal -->
    <div class="modal fade" id="processROIModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Process ROI</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.process.roi')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Processing Type</label>
                            <select name="type" class="form-control" required>
                                <option value="all">Process All Active Investments</option>
                                <option value="due">Process Only Due ROI</option>
                                <option value="specific">Process Specific Investment</option>
                            </select>
                        </div>
                        <div class="form-group" id="specificInvestmentGroup" style="display: none;">
                            <label>Investment ID</label>
                            <input type="number" name="investment_id" class="form-control" placeholder="Enter Investment ID">
                        </div>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>Note:</strong> This will process ROI calculations immediately. Make sure the system settings are correct before proceeding.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Process ROI</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Show/hide specific investment field
        document.querySelector('select[name="type"]').addEventListener('change', function() {
            const specificGroup = document.getElementById('specificInvestmentGroup');
            if (this.value === 'specific') {
                specificGroup.style.display = 'block';
                document.querySelector('input[name="investment_id"]').required = true;
            } else {
                specificGroup.style.display = 'none';
                document.querySelector('input[name="investment_id"]').required = false;
            }
        });

        // Process ROI for specific investment
        function processROI(investmentId) {
            if (confirm('Are you sure you want to process ROI for this investment now?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '<?php echo e(route("admin.process.roi")); ?>';

                const csrfToken = document.createElement('input');
                csrfToken.type = 'hidden';
                csrfToken.name = '_token';
                csrfToken.value = '<?php echo e(csrf_token()); ?>';

                const typeInput = document.createElement('input');
                typeInput.type = 'hidden';
                typeInput.name = 'type';
                typeInput.value = 'specific';

                const idInput = document.createElement('input');
                idInput.type = 'hidden';
                idInput.name = 'investment_id';
                idInput.value = investmentId;

                form.appendChild(csrfToken);
                form.appendChild(typeInput);
                form.appendChild(idInput);

                document.body.appendChild(form);
                form.submit();
            }
        }

        // Initialize DataTable
        $(document).ready(function() {
            $('#investmentTable').DataTable({
                order: [[0, 'desc']],
                pageLength: 25,
                responsive: true
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\algodebug\resources\views/admin/Plans/roi_management.blade.php ENDPATH**/ ?>